<?php

namespace App\Http\Controllers;


use App\Models\Notification;
use App\Models\ProjectStatus;
use \App\Models\User;
use App\Models\Project;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $users                  =   User::where('user_type_id',1)->count();
        $project_type_id        =   [];
        $project_status_id      =   [];
        $project_status_titles  =   [];
        $auth_user              =   Auth::user();

        if(Auth::user()->designation_id == 1){
            $project_type_id    =   [3];
            $project_status_id  =   [1];
            $project_type_title =   'In Progress';
        }

        elseif(Auth::user()->designation_id == 2){
            $project_type_id    =   [1];
            $project_status_id  =   [13];
            $project_type_title =   'To Do List';
        }

        elseif(Auth::user()->designation_id == 3){
            $project_type_id    =   [2];
            $project_status_id  =   [19];
            $project_type_title =   'Sales Projects';
        }

        elseif(Auth::user()->designation_id == 4){
            $project_type_id    =   [5];
            $project_status_id  =   [22];
            $project_type_title =   'To Design';
        }

        elseif(Auth::user()->designation_id == 5){
            $project_type_id    =   [4];
            $project_status_id  =   [21];
            $project_type_title =   'To Do List';
        }

        else{
            $project_type_id        =   [1, 2, 3, 4, 5];
            $project_status_id      =   ProjectStatus::whereIn('project_type_id', $project_type_id)->pluck('id');
            $project_status_titles  =   ProjectStatus::whereIn('id', $project_status_id)->get();
            $project_type_title     =   'All Projects';
        }

        $projects  =   Project::select('id', 'status_id', 'project_type_id', 'project_name', 'description', 'created_at')->whereIn('status_id', $project_status_id)->whereIn('project_type_id', $project_type_id)->distinct()->get();

        return view('dashboard',compact('users','projects', 'project_status_titles', 'project_type_title', 'auth_user'));
    }
}
