<?php

namespace App\Http\Controllers;

use App\Models\Notification;
use App\Models\NotificationSend;
use App\Models\Project;
use App\Models\ProjectStatus;
use App\Models\ProjectToUser;
use App\Models\ProjectType;
use App\Models\Role;
use App\Models\User;
use App\Models\UserStatus;
use App\Traits\EmailTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class ProjectController extends Controller
{
    use EmailTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){

//        if(auth()->user()->id == 1)
//        {
//            $project_ids    =   ProjectToUser::pluck('project_id');
//        }
//        else
//        {
//            $project_ids    =   ProjectToUser::where('user_id', auth()->user()->id)->pluck('project_id');
//        }
//
//        $projects_by_project_types =[];
//
//        foreach ($project_ids AS $key => $projects_by_user)
//        {
//            $projects_by_project_types[$key]  =   Project::where('id', $projects_by_user)->pluck('project_type_id');
//        }
////dd($projects_by_project_types);
//        $project_types          = ProjectType::whereIn('id', $projects_by_project_types)->orderBy('title')->get();
//        $project_types_array    = ProjectType::whereIn('id', $projects_by_project_types)->orderBy('title')->pluck('id');
//
//        $projects = [];
//        foreach ($project_types_array as $key => $project){
//            $projects[$key] = Project::where('project_type_id', $project)->whereIn('id', $project_ids)->get();
//        }

        $project_types = ProjectType::orderBy('title')->get();
        $project_types_array = ProjectType::orderBy('title')->pluck('id');
        $projects = [];
        foreach ($project_types_array as $key => $project){
            $projects[$key] = Project::where('project_type_id', $project)->get();
        }
        return view('projects.index', compact('project_types', 'project_types_array', 'projects'));
    }

    public function showAllProjects(Request $request){

        $columns_list = array(
            0 => 'id',
            1 => 'project_name',
            3 => 'start_date',
            4 => 'end_date',
            5 => 'account_manager_user_id',
            6 => 'project_manager_user_id',
            7 => 'client_id',
            2 => 'project_type_id',
            12=> 'status_id',
        );

        $totalDataRecord = Project::all()->count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'projects.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Project::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');

            $post_data =  Project::where('id','LIKE',"%{$search_text}%")
                ->orWhere('project_name', 'LIKE',"%{$search_text}%")
                ->orWhere('start_date', 'LIKE',"%{$search_text}%")
                ->orWhere('end_date', 'LIKE',"%{$search_text}%")
                ->orWhere('account_manager_user_id', 'LIKE',"%{$search_text}%")
                ->orWhere('project_manager_user_id', 'LIKE',"%{$search_text}%")
                ->orWhere('client_id', 'LIKE',"%{$search_text}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Project::where('id','LIKE',"%{$search_text}%")
                ->orWhere('project_name', 'LIKE',"%{$search_text}%")
                ->orWhere('start_date', 'LIKE',"%{$search_text}%")
                ->orWhere('end_date', 'LIKE',"%{$search_text}%")
                ->orWhere('account_manager_user_id', 'LIKE',"%{$search_text}%")
                ->orWhere('project_manager_user_id', 'LIKE',"%{$search_text}%")
                ->orWhere('client_id', 'LIKE',"%{$search_text}%")
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $deletedata = $post_val->id;
                $id         = base64_encode($deletedata);
                $dataedit   = route('edit.project',['id'=>$id]);
                $status     = $post_val->findProjectStatus->title??'N/A';

                $delete_project = Gate::allows("delete.project")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_project = Gate::allows("edit.project")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['project_name'] = $post_val->project_name;
                $postnestedData['start_date'] = $post_val->start_date;
                $postnestedData['end_date'] = $post_val->end_date;
                $postnestedData['account_manager_user_id'] = $post_val->findAccountManager->name??'N/A';
                $postnestedData['project_manager_user_id'] = $post_val->findProjectManager->name??'N/A';
                $postnestedData['client_id'] = $post_val->findClient->name??'N/A';
                $postnestedData['project_type_id'] = $post_val->findType->title??'';
                $postnestedData['status_id'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_project}  {$delete_project}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);
    }

    public function showAllProjects2(Request $request){

        $columns_list = array(
            0 => 'id',
            1 => 'project_name',
            3 => 'start_date',
            4 => 'end_date',
            5 => 'account_manager_user_id',
            6 => 'project_manager_user_id',
            7 => 'client_id',
            2 => 'project_type_id',
            12=> 'status_id',
        );

        $project_type_id = $request->project_type_id;
        $totalDataRecord = Project::where('project_type_id', $project_type_id)->count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'projects.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Project::where('project_type_id', $project_type_id)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');

            $post_data =  Project::where('project_type_id', $project_type_id)
                ->where(
                    function($query) use ($search_text){
                        $query->where('id','LIKE',"%{$search_text}%")
                            ->orWhere('project_name', 'LIKE',"%{$search_text}%")
                            ->orWhere('start_date', 'LIKE',"%{$search_text}%")
                            ->orWhere('end_date', 'LIKE',"%{$search_text}%")
                            ->orWhere('account_manager_user_id', 'LIKE',"%{$search_text}%")
                            ->orWhere('project_manager_user_id', 'LIKE',"%{$search_text}%")
                            ->orWhere('client_id', 'LIKE',"%{$search_text}%");
                    })
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Project::where('project_type_id', $project_type_id)->where(
                function ($query) use ($search_text){
                    $query->where('id','LIKE',"%{$search_text}%")
                        ->orWhere('project_name', 'LIKE',"%{$search_text}%")
                        ->orWhere('start_date', 'LIKE',"%{$search_text}%")
                        ->orWhere('end_date', 'LIKE',"%{$search_text}%")
                        ->orWhere('account_manager_user_id', 'LIKE',"%{$search_text}%")
                        ->orWhere('project_manager_user_id', 'LIKE',"%{$search_text}%")
                        ->orWhere('client_id', 'LIKE',"%{$search_text}%");
                })->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $deletedata = $post_val->id;
                $id         = base64_encode($deletedata);
                $dataedit   = route('edit.project',['id'=>$id]);
                $status     = $post_val->findProjectStatus->title??'N/A';

                $delete_project = Gate::allows("delete.project")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_project = Gate::allows("edit.project")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['project_name'] = $post_val->project_name;
                $postnestedData['start_date'] = $post_val->start_date;
                $postnestedData['end_date'] = $post_val->end_date;
                $postnestedData['account_manager_user_id'] = $post_val->findAccountManager->name??'N/A';
                $postnestedData['project_manager_user_id'] = $post_val->findProjectManager->name??'N/A';
                $postnestedData['client_id'] = $post_val->findClient->name??'N/A';
                $postnestedData['project_type_id'] = $post_val->findType->title??'';
                $postnestedData['status_id'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_project}  {$delete_project}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);
    }

    public function create(){
        $users = User::where('user_type_id', 1)->orderBy('name')->get();
        $clients = User::where('user_type_id', 2)->orderBy('name')->get();
        $project_types = ProjectType::where('status', 1)->orderBy('title')->get();

        $roles = Role::where('name', 'Client')->get();
        $status = UserStatus::where('status', 1)->where(function ($query){
            $query->where('title', 'Active')->orWhere('title', 'Blocked');
        })->orderBy('title')->get();

        return view('projects.create', compact('users', 'project_types', 'clients', 'roles', 'status'));
    }

    public function store(Request $request){

        $request->validate([
            "project_name" => "required",
            "start_date" => "required",
            "end_date" => "required",
            "description" => "required",
            "account_manager_user_id" => "required",
            "project_manager_user_id" => "required",
//            "client_id" => "required",
            "status_id" => "required",
            "project_type_id" => "required",
        ]);

        $request->merge([
            'description' => json_encode($request->description),
            'start_date'  => Carbon::make($request->start_date),
            'end_date'    => Carbon::make($request->end_date),
        ]);

        $project = Project::create($request->all());

        $notification_data = [
            'subject'=>$request->project_name,
            'description'=>$request->description,
            'from_user_id' =>auth()->user()->id,
            'notification_type'=>'Create Project Notification',
            'route'=> 'site/team-work/tasks/'.$project->id,
        ];

        $notification = Notification::create($notification_data);

        //Insert Data into project_to_users
        $project_users[] = $request->account_manager_user_id;
        $project_users[] = $request->project_manager_user_id;
        $project_users   = array_merge($project_users, json_decode($request->project_users));
        $project_users   = array_unique($project_users); //Remove duplicate values from array

        foreach ($project_users as $project_user){
            DB::table('project_to_users')->insert([
                'project_id' => $project->id,
                'user_id'    => $project_user,
            ]);

            if($project_user != Auth::user()->id){
                $general_notification = [
                    'notification_id'=>$notification->id,
                    'to_send'=>$project_user,
                    'is_read' =>0,
                ];
                NotificationSend::create($general_notification);
            }
        }

        if (!empty($project_users)){
            $this->sendNewProjectMail($project_users, $project);
        }

        mkdir(public_path().'/team-work/project_files/'.$project->slug);
        return redirect()->route('project')->with('mesg', 'Project created successfully');
    }

    public function edit($id){
        $id = base64_decode($id);
        $project = Project::find($id);
        if ($project){
            $users = User::where('user_type_id', 1)->orderBy('name')->get();
            $clients = User::where('user_type_id', 2)->orderBy('name')->get();
            $project_types = ProjectType::where('status', 1)->orderBy('title')->get();
            $project_status = ProjectStatus::where(['status' => 1, 'project_type_id' => $project->project_type_id])->orderBy('title')->get();

            $project_users = DB::table('project_to_users')
                ->select('*')
                ->where('project_id', $project->id)
                ->pluck('user_id')
                ->toArray();

            $roles = Role::where('name', 'Client')->get();
            $user_status = UserStatus::where('status', 1)->where(function ($query){
                $query->where('title', 'Active')->orWhere('title', 'Blocked');
            })->orderBy('title')->get();

            return view('projects.edit',
                compact('users', 'project_status', 'project', 'clients', 'project_types', 'project_users', 'roles', 'user_status'));
        }else{
            return redirect()->back()->with('error','Project not found.');
        }
    }

    public function show($id){
        dd($id);
    }

    public function update(Request $request){
        $request->validate([
            "project_name" => "required",
            "start_date" => "required",
            "end_date" => "required",
            "description" => "required",
            "account_manager_user_id" => "required",
            "project_manager_user_id" => "required",
            //"client_id" => "required",
            "status_id" => "required",
            "project_type_id" => "required",
        ]);

        $request->merge([
            'description' => json_encode($request->description),
            'start_date' => Carbon::make($request->start_date),
            'end_date' => Carbon::make($request->end_date),
        ]);

        $project = Project::find($request->id);
        if ($project){

            //Delete previous users related with project
            DB::table('project_to_users')->where('project_id', $project->id)->delete();

            //Add New users to the project
            $project_users[] = $request->account_manager_user_id;
            $project_users[] = $request->project_manager_user_id;
            $project_users   = array_merge($project_users, json_decode($request->project_users));
            $project_users   = array_unique($project_users); //Remove duplicate values from array

            foreach ($project_users as $project_user){
                DB::table('project_to_users')->insert([
                    'project_id' => $project->id,
                    'user_id'    => $project_user,
                ]);
            }

            $res = $project->update($request->all());
            if ($project->slug = null){
                $project->update(['title' => $project->project_name]);
            }
            if ($res){
                return redirect()->route('project')->with('mesg','Project updated successfully.');
            }
        }
    }

    public function delete($id){
        $project = Project::find(base64_decode($id));
        if($project){
            $project->delete();
            return response('Project deleted successfully');
        }else{
            return response('Project not found');
        }
    }

}
