<?php

namespace App\Http\Controllers;

use App\Models\DisbursedSalary;
use App\Models\GeneratedSalary;
use App\Models\Loan;
use App\Models\LoanInstallments;
use App\Models\Salary;
use App\Models\Team;
use App\Models\User;
use App\Models\UserLoginDetails;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Gate;

class SalaryController extends Controller
{
    public function index(){
        return view('user-salary.index');
    }

    public function showSalary(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2=> 'team_head_id',
            3=> 'status',
        );

        $totalDataRecord = Team::count();
        $totalFilteredRecord = $totalDataRecord;
        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'teams.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Team::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $id = base64_encode($post_val->id);
                $data =  route('show.user.salary',['id'=>$id]);
                $disbursed =  route('show.disbursed',['id'=>$id]);

                $show_user = Gate::allows("show.user.salary")?"<a class='btn btn-primary btn-style' href='{$data}' title='View'>Generate</a>":"";
                $disburse_history = Gate::allows("show.disbursed")?"<a class='btn btn-primary btn-style' href='{$disbursed}' title='Disbursed History'><i class='fa fa-clock'></i></a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['team_head_user_id'] = $post_val->findUser->name??'N/A';
                $postnestedData['options'] = " <div class='btn-group'> {$show_user}  </div>";
                $postnestedData['disburse'] = " <div class='btn-group'> {$disburse_history} </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);
    }

    public function show($id){
        $id = base64_decode($id);
        $team_member = Team::find($id);
        return view('user-salary.show',compact('team_member'));
    }

    public function showDisbursed($id){
        $id = base64_decode($id);
        $team_member = Team::find($id);
        return view('user-salary.disbursed',compact('team_member'));
    }

    public function teamSalary(Request $request){
        $columns_list = array(
            0 => 'id',
            7 => 'name',
            12=> 'basic_salary',
            2=> 'user_type_id',
        );
        $team_users = User::whereHas('findTeams',function ($query) use($request){
            $query->where("team_id",$request->id);
        })->get();

        $totalDataRecord = $team_users->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users.' . $columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = User::whereHas('findStatus', function ($query){
                $query->where('has_access',1);
                $query->orWhere('has_access',0)
                    ->where('users.leaving_date','LIKE','%'.(new Carbon)->timezone('Asia/Karachi')->subMonth()->format('m-Y'));
            })
                ->whereHas('findTeams', function ($query) use($request){
                    $query->where('team_id',$request->id);
                })
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        } else {
            $search_text = $request->input('search.value');

            $post_data = User::where('name', 'LIKE', "%{$search_text}%")
                ->whereHas('findTeams', function ($query) use($request){
                    $query->where('team_id',$request->id);
                })
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order, $dir_val)
                ->get();

            $totalFilteredRecord = User::where('id', 'LIKE', "%{$search_text}%")
                ->orWhere('name', 'LIKE', "%{$search_text}%")
                ->orWhere('client_display_name', 'LIKE', "%{$search_text}%")
                ->count();
        }

        $data_val = array();

        if (!empty($post_data)) {

            $i = 0;
            $user_login = new UserLoginDetails();
            $user_salary = new Salary();
            $previous_month = (new Carbon)->timezone('Asia/Karachi')->subMonth()->format('Y-m');
            foreach ($post_data as $post_val) {

                $data = DisbursedSalary::where('user_id',$post_val->id)->where('month_year',$previous_month)->first();

                $userAllownce = $user_salary->userAllownce($post_val->id);

                // total worked hours in Month
                $total_worked_hours = $user_login->getEmployeeWorkingHour($post_val->id,$previous_month);
                $total_worked_hours = $user_salary->secondsToHours($total_worked_hours);

                // total working hours in Month
                $total_month_working_days = $user_login->getMonthWorkingDays($previous_month);
                $shift_total_hour = substr($post_val->findShift->total_hours, 0, 2);
                $working_hour_total = ($shift_total_hour * $total_month_working_days);

                // total working days available
                $total_month_avaliable_days = $user_login->getEmployeeWorkingDays($post_val->id,$previous_month);

                // over time
                $over_time_hours =  $user_login->overtime($post_val->id,$previous_month);
                $over_time_hours =  $user_salary->secondsToHours($over_time_hours);

                $total_salary = round($post_val->total_salary, 2);

                // Calculate Salary
                $hour_salary = ($total_salary/$working_hour_total);
                $leave = $user_salary->leaves($post_val->id);

                $other_calculation  = $user_salary->otherCalculation($post_val->id);

                // unpaid leave
                $unpaid = 0;
                if (isset($other_calculation) && $other_calculation->unpaid_leave == 1) {
                    if (!empty($leave['unpaid'])) {
                        $unpaid_day = array_sum($leave['unpaid']);
                        $unpaid_day_hour = ($unpaid_day * $shift_total_hour);
                        $unpaid = ($unpaid_day_hour * $hour_salary);
                    }
                }

                // paid leave
                $paid = 0;
                if (!empty($leave['paid'])) {
                    $paid_day = array_sum($leave['paid']);
                    $paid_day_hour = ($paid_day * $shift_total_hour);
                    $paid = ($paid_day_hour * $hour_salary);
                }

                // Mark as Late in
                $mark_as_late_deduction_total = 0;
                if (isset($other_calculation) && $other_calculation->late_in == 1){
                    $mark_as_late = $user_salary->userMarkAsLate($post_val->id,$previous_month);
                    $mark_as_late = ($mark_as_late * $shift_total_hour);
                    $mark_as_late_deduction_total = ($mark_as_late * $hour_salary);
                }

                // Mark as Early out
                $mark_as_early_out_deduction_total = 0;
                if (isset($other_calculation) && $other_calculation->early_out == 1){
                    $mark_as_early_out = $user_salary->userMarkedAsEarlyOut($post_val->id,$previous_month);
                    $mark_as_early_out = ($mark_as_early_out * $shift_total_hour);
                    $mark_as_early_out_deduction_total = ($mark_as_early_out * $hour_salary);
                }
                // Over Time
                $over_time_hour = 0;
                /*if (isset($other_calculation) && $other_calculation->overtime == 1){
                    $over_time_hour = ($hour_salary*$over_time_hours);
                }*/
                /*if (isset($other_calculation) && $other_calculation->overtime_hours > 0){
                    $over_time_hour = ($other_calculation->overtime_hours);
                }else{
                    $over_time_hour = $over_time_hours;
                }*/

                $bonus = 0;
                if (isset($other_calculation) && $other_calculation->bonus_amount > 0){
                    $bonus = $other_calculation->bonus_amount;
                }

                $over_time_hour = $over_time_hours;

                $salary = ($hour_salary * $total_worked_hours);
                $salary = ($salary + $paid);
                $salary = ($salary - $unpaid);
                $salary = ($salary + $over_time_hour);
                $salary = ($salary - $mark_as_late_deduction_total);
                $salary = ($salary - $mark_as_early_out_deduction_total);

                // salary after tax deduction
                $salary_after_tax_deduction = $user_salary->taxDeduction($salary);

                // total tax on monthly salary
                $total_tax_on_salary = ($salary - $salary_after_tax_deduction);
                $salary_after_tax_deduction = ($salary_after_tax_deduction + $bonus);
                $update_disbursed = route('update.disbursed.status',['id'=>base64_encode($post_val->id)]);

                $viewEmployeeDetails = route('show.user',['id'=>base64_encode($post_val->id)]);
                $show_user = "<a href='{$viewEmployeeDetails}' title='View'>$post_val->name</a>";

                $disburse ='';
                if (isset($data) && $data->disbursed_status == 0){
                    $id = $post_val->id;
                    $disburse = "<button class='btn btn-primary update_disburse' id='loading{$id}' data-id='{$id}'><i></i> Disburse</button>";
                }elseif(isset($data) && $data->disbursed_status == 1 ){
                    $disburse = "<span class='badge badge-success'>Disbursed</span>";
                }

                $i++;
                $postnestedData['id'] = $i;
                $postnestedData['name'] = $show_user??'N/A';
                $postnestedData['net_salary'] = (int)$salary_after_tax_deduction??'';
                $postnestedData['salary_tax'] = (int)$total_tax_on_salary??'';
                $postnestedData['basic_salary'] = $post_val->basic_salary;
                $postnestedData['medical_allowance'] = $userAllownce['1']??'N/A';
                $postnestedData['transportation_allowance'] = $userAllownce['3']??'N/A';
                $postnestedData['mobile_allowance'] = $userAllownce['4']??'N/A';;
                $postnestedData['working_days'] =   '<span class="badge badge-success">'.$total_month_avaliable_days." / ".$total_month_working_days.'</span>';
                $postnestedData['total_salary'] = $post_val->total_salary;
                $postnestedData['over_time'] = round($over_time_hour,2);
                $postnestedData['bonus_amount'] = round($bonus,2);
                $postnestedData['yes_no_fields'] =(!empty($data))?'':"<button class='btn btn-primary btn-style yes_no_fields action' data-overtime='".round($over_time_hour,2)."' data-total='".((int)round($salary_after_tax_deduction, 2))."' data-id='{$post_val->id}' data-toggle='modal' data-target='#exampleModalCenter' title='View'><i class='fa fa-calculator'></i> </button>";
                $postnestedData['disbursed-status'] ="{$disburse}";
                $data_val[] = $postnestedData;

            }
        }

        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw" => intval($draw_val),
            "recordsTotal" => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data" => $data_val
        );
        echo json_encode($get_json_data);
    }

    public function disbursedHistory(Request $request){
        $columns_list = array(
            0 => 'id',
            2 => 'basic_salary',
            3 => 'medical_allowance',
            4 => 'transportation_allowance',
            5 => 'mobile_allowance',
            6 => 'total_salary',
            7 => 'salary_tax',
            8 => 'net_salary',
            9 => 'working_days',
            10 => 'over_time',
            11 => 'mark_as_late',
            12 => 'mark_as_early_out',
            13 => 'unpaid_leave',
            14 => 'paid_leave',
            15 => 'updated_at',
            16 => 'loan_installment',
        );
        $team_users = User::whereHas('findTeams',function ($query) use($request){
            $query->where("team_id",$request['id']);
        })->get();

        $totalDataRecord = $team_users->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'salaries_disbursed.' . $columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        $month_year = (new Carbon)->timezone('Asia/Karachi')->subMonth()->format('Y-m');
        $user = User::whereHas('findStatus', function ($query){
            $query->where('has_access',1);
        })->whereHas('findTeams', function ($query) use ($request){
            $query->where('team_id',$request['id']);
        })->pluck('id')->toArray();

        if (isset($request['month']) && $request['month']!=null){
            $month_year = $request['month'];
        }

        if(empty($request->input('search.value')))
        {
            $post_data =DisbursedSalary::whereIn('user_id',array_values($user))
                ->where('month_year',$month_year)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        } else {
            $search_text = $request->input('search.value');

            $post_data = User::where('name', 'LIKE', "%{$search_text}%")
                ->whereHas('findTeams', function ($query) use($request){
                    $query->where('team_id',$request->id);
                })
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order, $dir_val)
                ->get();

            $totalFilteredRecord = User::where('id', 'LIKE', "%{$search_text}%")
                ->orWhere('name', 'LIKE', "%{$search_text}%")
                ->orWhere('client_display_name', 'LIKE', "%{$search_text}%")
                ->count();
        }

        $data_val = array();

        if (!empty($post_data)) {

            $i = 0;
            foreach ($post_data as $post_val) {

                $i++;
                $postnestedData['id'] = $i;
                $postnestedData['name'] = $post_val->findUser->name??'N/A';
                $postnestedData['basic_salary'] = $post_val->basic_salary??'N/A';
                $postnestedData['medical_allowance'] = $post_val->medical_allowance??'N/A';
                $postnestedData['transportation_allowance'] = $post_val->transportation_allowance??'N/A';
                $postnestedData['mobile_allowance'] = $post_val->mobile_allowance??'N/A';
                $postnestedData['total_salary'] = $post_val->total_salary??'N/A';
                $postnestedData['salary_tax'] = $post_val->salary_tax??'N/A';
                $postnestedData['net_salary'] = $post_val->net_salary??'N/A';
                $postnestedData['working_days'] = $post_val->working_days??'N/A';
                $postnestedData['over_time'] = $post_val->over_time??'N/A';
                $postnestedData['mark_as_late'] = $post_val->mark_as_late??'N/A';
                $postnestedData['mark_as_early_out'] = $post_val->mark_as_early_out??'N/A';
                $postnestedData['mark_as_early_out'] = $post_val->unpaid_leave??'N/A';
                $postnestedData['paid_leave'] = $post_val->paid_leave??'N/A';
                $postnestedData['unpaid_leave'] = $post_val->paid_leave??'N/A';
                $postnestedData['loan_installment'] = $post_val->loan_installment??'N/A';
                $postnestedData['updated_at'] = (\Carbon\Carbon::make($post_val->updated_at)->format('d-m-Y i:h:s a'))??'N/A';
                $data_val[] = $postnestedData;
            }
        }

        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw" => intval($draw_val),
            "recordsTotal" => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data" => $data_val
        );
        echo json_encode($get_json_data);
    }

    public function generatedSalary(Request $request){
        $date = now()->format('Y-m');
        $res = GeneratedSalary::where('created_at','LIKE',"%{$date}%")->updateOrCreate(['user_id'=>$request->user_id],$request->all());
        if ($res){
            return response()->json(['status' => true]);
        }else{
            return response()->json(['status' => false]);
        }
    }

    public function showGeneratedSalary($id){
        $loan = Loan::where('user_id',$id)->whereIn('status',['Disbursed','In-Process'])->first();
        if ($loan){
            $status = true;
        }else{
            $status = false;
        }

        $date = now()->format('Y-m');
        $data = GeneratedSalary::where('user_id',$id)->where('created_at','LIKE',"%{$date}%")->first();
        return response()->json(['generated_salary'=>$data,'loans'=>$loan,'status' => $status]);
    }

    public function disburseSalary(Request $request){

        $post_data = User::whereHas('findStatus', function ($query){
            $query->where('has_access',1);
            $query->orWhere('has_access',0)
                ->where('users.leaving_date','LIKE','%'.(new Carbon)->timezone('Asia/Karachi')->subMonth()->format('m-Y'));
        })
            ->whereHas('findTeams', function ($query) use($request){
                $query->where('team_id',$request->id);
            })->get();

        if (!empty($post_data)) {

            $user_login = new UserLoginDetails();
            $user_salary = new Salary();
            foreach ($post_data as $post_val) {

                $userAllownce = $user_salary->userAllownce($post_val->id);
                // total worked hours in Month
                $previous_month = (new Carbon)->timezone('Asia/Karachi')->subMonth()->format('Y-m');

                $total_worked_hours = $user_login->getEmployeeWorkingHour($post_val->id,$previous_month);
                $total_worked_hours = $user_salary->secondsToHours($total_worked_hours);

                // total working hours in Month
                $total_month_working_days = $user_login->getMonthWorkingDays($previous_month);
                $shift_total_hour = substr($post_val->findShift->total_hours, 0, 2);
                $working_hour_total = ($shift_total_hour * $total_month_working_days);

                // total working days available
                $total_month_avaliable_days = $user_login->getEmployeeWorkingDays($post_val->id,$previous_month);

                // over time
                $over_time_hours = $user_login->overtime($post_val->id,$previous_month);
                $over_time_hours = $user_salary->secondsToHours($over_time_hours);

                $total_salary = round($post_val->total_salary, 2);

                // Calculate Salary
                $hour_salary = ($total_salary/$working_hour_total);
                $leave = $user_salary->leaves($post_val->id);

                $other_calculation = $user_salary->otherCalculation($post_val->id);

                // unpaid leave
                $unpaid = 0;
                if (isset($other_calculation) && $other_calculation->unpaid_leave == 1) {
                    if (!empty($leave['unpaid'])) {
                        $unpaid_day = array_sum($leave['unpaid']);
                        $unpaid_day_hour = ($unpaid_day * $shift_total_hour);
                        $unpaid = ($unpaid_day_hour * $hour_salary);
                    }
                }

                // paid leave
                $paid = 0;
                if (!empty($leave['paid'])) {
                    $paid_day = array_sum($leave['paid']);
                    $paid_day_hour = ($paid_day * $shift_total_hour);
                    $paid = ($paid_day_hour * $hour_salary);
                }

                // Mark as Late in
                $mark_as_late_deduction_total = 0;
                if (isset($other_calculation) && $other_calculation->late_in == 1){
                    $mark_as_late = $user_salary->userMarkAsLate($post_val->id,$previous_month);
                    $mark_as_late = ($mark_as_late * $shift_total_hour);
                    $mark_as_late_deduction_total = ($mark_as_late * $hour_salary);
                }

                // Mark as Early out
                $mark_as_early_out_deduction_total = 0;
                if (isset($other_calculation) && $other_calculation->early_out == 1){
                    $mark_as_early_out = $user_salary->userMarkedAsEarlyOut($post_val->id,$previous_month);
                    $mark_as_early_out = ($mark_as_early_out * $shift_total_hour);
                    $mark_as_early_out_deduction_total = ($mark_as_early_out * $hour_salary);
                }

                // overtime
                $over_time_hour = 0;
                /*if (isset($other_calculation) && $other_calculation->overtime == 1){
                    $over_time_hour = ($hour_salary*$over_time_hours);
                }*/

                if (isset($other_calculation) && $other_calculation->overtime_hours > 0){
                    $over_time_hour = ($hour_salary*$other_calculation->overtime_hours);
                }

                $bonus = 0;
                if (isset($other_calculation) && $other_calculation->bonus_amount > 0){
                    $bonus = $other_calculation->bonus_amount;
                }

                // Loan Deduction
                $loan_amount = 0;
                if (isset($other_calculation) && $other_calculation->loan == 1){

                    $loan = Loan::where('user_id',$post_val->id)->whereIn('status',['Disbursed','In-Process'])->first();

                    if (isset($loan) && isset($loan->loan_deduction_month)){
                        $disbursement_date = Carbon::make('01-'.$loan->loan_deduction_month)->format('Y-m');
                        if (now()->format('Y-m') >= $disbursement_date){
                            $loan->update(['status' =>'In-Process']);
                            if ($loan->number_of_installments_remaining != 0){
                                $loan->number_of_installments_remaining = $loan->number_of_installments_remaining - 1;
                                $loan->amount_returned = $loan->amount_returned + $loan->installment_amount;
                                $loan_amount = $loan->installment_amount;
                                $loan->update(['number_of_installments_remaining' => $loan->number_of_installments_remaining,'amount_returned'=>$loan->amount_returned]);
                                LoanInstallments::create(['loan_id'=>$loan->id,'amount'=>$loan->installment_amount]);

                                if ($loan->number_of_installments_remaining == 0){
                                    $loan->update(['status'=>'Returned']);
                                }
                            }
                        }
                    }
                }

                $salary = ($hour_salary * $total_worked_hours);
                $salary = ($salary + $paid);
                $salary = ($salary - $unpaid);
//                $salary = ($salary + $over_time_hour);
                $salary = ($salary - $mark_as_late_deduction_total);
                $salary = ($salary - $mark_as_early_out_deduction_total);
                $salary = ($salary - $loan_amount);

                // salary after tax deduction
                $salary_after_tax_deduction = $user_salary->taxDeduction($salary);

                // total tax on monthly salary
                $total_tax_on_salary = ($salary - $salary_after_tax_deduction);

                $salary_after_tax_deduction += $over_time_hour;
                $salary_after_tax_deduction += $bonus;

                $late = $user_salary->userMarkAsLate($post_val->id,$previous_month);
                $late = ($late * $shift_total_hour);
                $late = ($late * $hour_salary);

                $early = $user_salary->userMarkedAsEarlyOut($post_val->id,$previous_month);
                $early = ($early * $shift_total_hour);
                $early = ($early * $hour_salary);

                if (!empty($leave['unpaid'])) {
                    $unpaid = array_sum($leave['unpaid']);
                    $unpaid = ($unpaid * $shift_total_hour);
                    $unpaid = ($unpaid * $hour_salary);
                }

                $disbursed_salary = [
                    "user_id" => $post_val->id,
                    "basic_salary" => $post_val->basic_salary,
                    "medical_allowance" => $userAllownce['1']??'0',
                    "transportation_allowance" => $userAllownce['3']??'0',
                    "mobile_allowance" => $userAllownce['4']??'0',
                    "total_salary" => $post_val->total_salary,
                    "salary_tax" => $total_tax_on_salary,
                    "net_salary" => $salary_after_tax_deduction,
                    "working_days" => $total_month_avaliable_days."/".$total_month_working_days,
                    "over_time" => $over_time_hour,
                    "mark_as_late" => $late,
                    "mark_as_early_out" => $early,
                    "unpaid_leave" => $unpaid,
                    "paid_leave" => $paid,
                    "month_year" => $previous_month,
                    "loan_installment" => $loan_amount,
                    "bonus_amount" => $bonus,
                    "disbursed_status" => 1, // This will update according to transaction response
                ];

                DisbursedSalary::Create($disbursed_salary);
            }
            return response(['message'=>'Successfully Disbursed Salary']);
        }
    }

    public function disbursedStatus(Request $request){

        $month_year = (new Carbon)->timezone('Asia/Karachi')->subMonth()->format('Y-m');
        $user = User::whereHas('findStatus', function ($query){
            $query->where('has_access',1);
        })->whereHas('findTeams', function ($query) use($request){
            $query->where('team_id',$request->team_id);
        })->pluck('id')->toArray();

        $users = array_values($user);
        $res = DisbursedSalary::whereIn('user_id',$users)->where('month_year',$month_year)->count();
        return response(['user'=> $res]);
    }

    public function updateDisburse(Request $request){
       DisbursedSalary::where('user_id',(int)$request['id'])->update(['disbursed_status' => 1]);
        return response('success');
    }
}
