<?php

namespace App\Http\Controllers;

use App\Models\Notification;
use App\Models\NotificationSend;
use App\Models\Project;
use App\Models\ProjectComment;
use App\Models\ProjectStatus;
use App\Models\ProjectToUser;
use App\Models\ProjectType;
use App\Models\User;
use App\Traits\EmailTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TeamWorkController extends Controller
{
    use EmailTrait;
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index($project_type = ""){
        if (!empty($project_type)){
            $project_type = ProjectType::find(base64_decode($project_type));
            if (!$project_type)
                abort(404);
        }else{
            abort(404);
        }
        $users = User::where('user_type_id', 1)
            ->whereHas('findStatus', function($query) {
                $query->where('has_access', 1);
            })
            ->get();

        $project_status = ProjectStatus::where(['project_type_id' => $project_type->id, 'status' => 1])->orderBy('sort_order')->get();
        $project_status_array = ProjectStatus::where(['project_type_id' => $project_type->id, 'status' => 1])->orderBy('sort_order')->pluck('id');

        return view('team-work.board', compact('project_status', 'project_status_array', 'project_type', 'users'));
    }

    public function task($id){
        $project = Project::find($id);
        if ($project){
            $project_comments = ProjectComment::where(['project_id' => $id, 'status' => 1])->orderBy('created_at', 'DESC')->get();
            $comments = (String) view('team-work.comments_ajax', compact('project', 'project_comments'));
            $users = User::where('user_type_id', 1)
                ->whereHas('findStatus', function($query) {
                    $query->where('has_access', 1);
                })
                ->get();
            return view('team-work.task', compact('project', 'comments', 'users'));
        }else{
            abort(404);
        }
    }

    public function fetchProject($id){

        $projects = Project::where('status_id', $id)->get();

//        $project_to_user    =   ProjectToUser::where('project', $projects->project_id)->get();
//
//        dd($project_to_user);
//        exit;
        $html = "";
        if (count($projects) > 0){
            foreach ($projects as $project){
                $project_start = Carbon::make($project->start_date)->format('dS M y');
                $project_end = Carbon::make($project->end_date)->format('dS M y');
                $html .= '<a href="'.route('team-work.tasks', $project->id).'" class="project-link" data-title="'.$project->project_name.'" data-toggle="modal" id="task'.$project->id.'">';
                $html .= '<div class="coloumn-body pull-left" data-title="'.$project->project_name.'" data-toggle="modal" id="task'.$project->id.'" draggable="true" ondragstart="drag(event)">';
                $html .= '    <ul>';
                $html .= '        <li>'.$project->project_name.'</li>';
                $html .= '        <li class="timestamp" style="float: right; margin: -15px 0px;font-size: 10px;">'.$project->updated_at->diffForHumans().'</li>';
                $html .= '    </ul>';
                $html .= '    <div class="status"><i class="fas fa-calendar"></i> '.$project_start.' - '.$project_end.'</div>';
                $html .= '</div>';
                $html .= '</a>';
            }
        }else {
            $html .= " ";
        }

        return $html;
    }

    public function updateProjectStatus(Request $request){
        $project_status     = str_replace('-', ' ', $request->project_status);
        $task_id            = str_replace('task', '', $request->task_id);
        $project_status_id  = ProjectStatus::where('title', $project_status)->pluck('id');
        $project            = Project::find($task_id);

        $project_users      = $project->getProjectMembers($project->id);

        if (count($project_users) > 0){
            $this->sendMoveProjectMail($project_users, $project, $project_status);
        }

        if (count($project_status_id) > 0 && $project){
            $project->status_id = $project_status_id[0];
            $project->save();
            return true;
        }else{
            return false;
        }
    }

    public function storeProjectFiles(Request $request){
        $request->validate([
            'project_id' => 'required',
            'file_type' => 'required',
        ]);
        $project_id = $request->project_id;
        $file_type = str_replace('-', '_', $request->file_type);

        if ($request->hasFile('files')){
            $project = Project::find($project_id);

            if ($project){

                if(!is_dir(public_path() . '/team-work/project_files/'.$project->slug)){
                    mkdir(public_path() . '/team-work/project_files/'.$project->slug);
                }

                $file_names = json_decode($project->$file_type);
                foreach ($request->file('files') as $key => $file) {

                    // Get filename with the extension
                    $filenameWithExt = $file->getClientOriginalName();
                    // Get just filename
                    $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                    // Get just ext
                    $extension = $file->getClientOriginalExtension();
                    // Filename to store
                    $file_names[] = $fileNameToStore = $filename.'_'.time().$key.'.'.$extension;

                    $file->move(public_path() . '/team-work/project_files/'.$project->slug.'/', $fileNameToStore);
                }
                $project->$file_type = json_encode($file_names);
                $project->save();
                return $file_names;
            }else{
                return false;
            }
        }
    }

    public function storeProjectFilesDrop(Request $request){
        $request->validate([
            'project_id' => 'required',
            'file_type' => 'required',
        ]);

        $project_id = $request->project_id;
        $file_type = str_replace('-', '_', $request->file_type);

        if ($request->hasFile('file')){
            $project = Project::find($project_id);

            if ($project){

                if(!is_dir(public_path() . '/team-work/project_files/'.$project->slug)){
                    mkdir(public_path() . '/team-work/project_files/'.$project->slug);
                }

                $file_names = json_decode($project->$file_type);

                $file = $request->file('file');

                $file_name = $file->getClientOriginalName();


                $file_names[] = $fileNameToStore = $file_name;

                $file->move(public_path() . '/team-work/project_files/'.$project->slug.'/', $fileNameToStore);

                $project->$file_type = json_encode($file_names);
                $project->save();
                return $file_names;
            }else{
                return false;
            }
        }
    }

    public function saveProjectComment(Request $request){
        $res['status'] = false;
        $project_users = [];
        if (auth()->check()){
            $project = Project::find($request->project_id);
            if ($project){
                $res['status'] = true;
                $comment = ProjectComment::create([
                    'project_id'      =>    $request->project_id,
                    'description'     =>    json_encode($request->description),
                    'users_to_notify' =>    json_encode($request->notification_users),
                    'status'          =>    1,
                ]);

                $notification_data = [
                    'subject'           =>  $project->project_name,
                    'description'       =>  json_encode($request->description),
                    'from_user_id'      =>  auth()->user()->id,
                    'notification_type' =>  'Project Comment Notification',
                    'route'             =>  'site/team-work/tasks/'.$project->id.'?c='.$comment->id,
                ];

                $notification = Notification::create($notification_data);

                //Store Comment files
                if ($request->has('comment_files')){
                    $comment_files = [];
                    if (!file_exists(public_path().'/team-work/project_files/'.$project->slug.'/comment_files')){
                        mkdir(public_path().'/team-work/project_files/'.$project->slug.'/comment_files');
                    }

                    foreach ($request->comment_files as $key => $file){
                        $file_parts = explode('.', $file);
                        $newName = $file_parts[0].time().$key.'.'.$file_parts[1];
                        copy(
                            public_path().'/uploads/'.$file,
                            public_path().'/team-work/project_files/'.$project->slug.'/comment_files/'.$newName
                        );
                        $comment_files[] = $newName;
                        $comment->files  = json_encode($comment_files);
                    }
                }

                //Store and mail to corresponding users
                if ($request->has('notification_users')){
                    $project_users = $request->notification_users;
                    $comment->users_to_notify = json_encode($request->notification_users);
                }
                $comment->user_id = auth()->id();
                $comment->save();
                $res['comment'] = $this->commentHTML($comment->id);

                /*Send mail to each user here*/
                $project_members = $project->getProjectMembers($project->id);
                if (count($project_members) > 0){
                    $project_users = array_merge($project_users, $project_members);
                }

                foreach ($project_users as $project_user){
                    if($project_user != Auth::user()->id){
                        $general_notification = [
                            'notification_id'=>$notification->id,
                            'to_send'=>$project_user,
                            'is_read' =>0,
                        ];
                        NotificationSend::create($general_notification);
                    }
                }

                if (count($project_users) > 0){
                    $this->sendCommentMail($project_users, $project, $comment);
                }
            }
        }
        return $res;
    }

    public function deleteProjectComment(Request $request){
        $comment =  ProjectComment::find($request->id);
        $project = Project::find($comment->project_id);
        $comment_files = json_decode($comment->files);
        if ($comment_files != null){
            foreach ($comment_files as $file){
                if (file_exists(public_path().'/team-work/project_files/'.$project->slug.'/comment_files/'.$file)){
                    unlink(public_path().'/team-work/project_files/'.$project->slug.'/comment_files/'.$file);
                }
            }
        }
        return $comment->delete();
    }

    public function getProjectComments($id){
        $project = Project::find($id);
        $project_comments = ProjectComment::where(['project_id' => $id, 'status' => 1])->orderBy('created_at', 'DESC')->get();
        return (String) view('team-work.comments_ajax', compact('project', 'project_comments'));
    }

    public function getProjectFiles(Request $request){
        $res = ['status' => false];
        $project = Project::find($request->id);
        if($project){

            $res['status'] = true;
            $client_files = json_decode($project->client_files);
            $concept_files = json_decode($project->concept_files);
            $final_files = json_decode($project->final_files);

            $temp = "";
            if($client_files){
                foreach ($client_files as $file){

                    $exploded = explode('.', $file);

                    if ($exploded[1] == 'docx' || $exploded[1] == 'DOCX' || $exploded[1] == 'doc' ||
                        $exploded[1] == 'xlsx' || $exploded[1] == 'XLSX' ||
                        $exploded[1] == 'XLS' || $exploded[1] == 'xls' || $exploded[1] == 'xml') {
                        $urlPath = "https://view.officeapps.live.com/op/embed.aspx?src=".urlencode(\URL::to('/') . '/public/team-work/project_files/'.$project->slug.'/'.$file);
                    } else {
                        $urlPath = asset('team-work/project_files/'.$project->slug.'/'.$file);
                    }

                    $temp .= "<tr>";
                    $temp .= "<td><a href='".$urlPath."' data-fancybox data-type='iframe' data-preload='false'>$file</a></td>";
                    $temp .= "<td><div class='btn-group'>";
                    $temp .= "<a class='btn btn-primary btn-xs' href='".asset('team-work/project_files/'.$project->slug.'/'.$file)."' download=''><i class='fas fa-download'></i></a>";
                    $temp .= "<button class='btn btn-danger btn-xs remove-file' data-type='client_files' data-name='".$file."' data-id='".$project->id."'><i class='fa fa-times-circle'></i></button></div></td>";
                    $temp .= "</tr>";
                }
                $res['client_files'] = "<tr>".$temp."</tr>";
                $temp = "";
            }else{
                $res['client_files'] = ["<tr><td colspan='2'>No Files Found</td></tr>"];
            }

            if($concept_files){
                foreach ($concept_files as $file){
                    $exploded = explode('.', $file);

                    if ($exploded[1] == 'docx' || $exploded[1] == 'DOCX' || $exploded[1] == 'doc' ||
                        $exploded[1] == 'xlsx' || $exploded[1] == 'XLSX' ||
                        $exploded[1] == 'XLS' || $exploded[1] == 'xls' || $exploded[1] == 'xml') {
                        $urlPath = "https://view.officeapps.live.com/op/embed.aspx?src=".urlencode(\URL::to('/') . '/public/team-work/project_files/'.$project->slug.'/'.$file);
                    } else {
                        $urlPath = asset('team-work/project_files/'.$project->slug.'/'.$file);
                    }

                    $temp .= "<tr>";
                    $temp .= "<td><a href='".$urlPath."' data-fancybox data-type='iframe' data-preload='false'>$file</a></td>";
                    $temp .= "<td><div class='btn-group'>";
                    $temp .= "<a class='btn btn-primary btn-xs' href='".asset('team-work/project_files/'.$project->slug.'/'.$file)."' download=''><i class='fas fa-download'></i></a>";
                    $temp .= "<button class='btn btn-danger btn-xs remove-file' data-type='concept_files' data-name='".$file."' data-id='".$project->id."'><i class='fa fa-times-circle'></i></button></div></td>";
                    $temp .= "</tr>";
                }
                $res['concept_files'] = $temp;
                $temp = "";
            }else{
                $res['concept_files'] = ["<tr><td colspan='2'>No Files Found</td></tr>"];
            }

            if($final_files){
                foreach ($final_files as $file){
                    $exploded = explode('.', $file);

                    if ($exploded[1] == 'docx' || $exploded[1] == 'DOCX' || $exploded[1] == 'doc' ||
                        $exploded[1] == 'xlsx' || $exploded[1] == 'XLSX' ||
                        $exploded[1] == 'XLS' || $exploded[1] == 'xls' || $exploded[1] == 'xml') {
                        $urlPath = "https://view.officeapps.live.com/op/embed.aspx?src=".urlencode(\URL::to('/') . '/public/team-work/project_files/'.$project->slug.'/'.$file);
                    } else {
                        $urlPath = asset('team-work/project_files/'.$project->slug.'/'.$file);
                    }

                    $temp .= "<tr>";
                    $temp .= "<td><a href='".$urlPath."' data-fancybox data-type='iframe' data-preload='false'>$file</a></td>";
                    $temp .= "<td><div class='btn-group'>";
                    $temp .= "<a class='btn btn-primary btn-xs' href='".asset('team-work/project_files/'.$project->slug.'/'.$file)."' download=''><i class='fas fa-download'></i></a>";
                    $temp .= "<button class='btn btn-danger btn-xs remove-file' data-type='final_files' data-name='".$file."' data-id='".$project->id."'><i class='fa fa-times-circle'></i></button></div></td>";
                    $temp .= "</tr>";
                }
                $res['final_files'] = "<tr>".$temp."</tr>";
            }else{
                $res['final_files'] = ["<tr><td colspan='2'>No Files Found</td></tr>"];
            }
        }
        return $res;
    }

    public function deleteProjectFile(Request $request){
        $project = Project::find($request->project_id);
        $res = false;
        if($project){
            $type = $request->file_type;
            $files = json_decode($project->$type, true);
            if (($key = array_search($request->file_name,
                    $files)) !== false){
                if (file_exists(public_path().'/team-work/project_files/'.$project->slug.'/'.$request->file_name))
                    unlink(public_path().'/team-work/project_files/'.$project->slug.'/'.$request->file_name);
                unset($files[$key]);
                $project->$type = json_encode($files);
                $project->save();
                $res = true;
            }
        }
        return $res;
    }

    public function deleteProjectFileDrop(Request $request){
        $project = Project::find($request->project_id);
        $res = false;
        if($project){
            $type = $request->file_type;
            $files = json_decode($project->$type, true);
//            dd($request->file_name);
            if (($key = array_search($request->file_name,$files)) !== false){
                if (file_exists(public_path().'/team-work/project_files/'.$project->slug.'/'.$request->file_name))
                    unlink(public_path().'/team-work/project_files/'.$project->slug.'/'.$request->file_name);
                unset($files[$key]);
                $project->$type = json_encode($files);
                $project->save();
                $res = true;
            }
        }
        return $res;
    }

    public function storeCommentFile(Request $request){
        $file = $request->file('file');

        $file_name = $file->getClientOriginalName();

        $destinationPath = public_path('uploads');

        $file->move($destinationPath,$file_name);
    }

    public function deleteCommentFile($file_name){
        $path = public_path('uploads/'.$file_name);

        if(file_exists($path)){
            unlink($path);
            return response($file_name);
        }
    }

    public function commentHTML($comment_id){
        $project_comments = ProjectComment::where('id', $comment_id)->get();
        $project = Project::find($project_comments[0]->project_id);
        return (String) view('team-work.comments_ajax', compact('project', 'project_comments'));
    }
}
