<?php

namespace App\Http\Controllers;

use App\Models\UserDesignation;
use Illuminate\Http\Request;

class UserDesignationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $user_designations = UserDesignation::orderBy('title')->get();
        return view('user-designations.index', compact('user_designations'));
    }

    public function create(){
        return view('user-designations.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        UserDesignation::create($request->all());
        return redirect()->route('user-department')->with('mesg', 'User Designation created successfully');
    }

    public function edit($id){
        $user_designation = UserDesignation::find(base64_decode($id));
        if ($user_designation){
            return view('user-designations.edit', compact('user_designation'));
        }else{
            return redirect()->back()->with('error','User Department not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        $user_designation = UserDesignation::find($request->id);
        if ($user_designation){
            $res = $user_designation->update($request->all());
            if ($res){
                return redirect()->route('user-department')->with('mesg','User Department updated successfully.');
            }
        }
    }

    public function delete($id){
        $user_designation = UserDesignation::find(base64_decode($id));
        if($user_designation){
            $user_designation->delete();
            return response('User Department deleted successfully');
        }else{
            return response('User Department not found');
        }
    }
}
