<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveRequests extends Model
{
    use HasFactory;

    protected $table = 'users_leaves_requests';

    protected $guarded = [
        '_token',
    ];

    protected $dates = [
        'leave_from_date',
        'leave_end_date',
    ];

    public function findLeaveType(){
        return $this->belongsTo(LeaveType::class,'leave_type_id');
    }

    public function findUser(){
        return $this->belongsTo(User::class,'user_id');
    }
}
