<?php

namespace App\Providers;

use App\Models\Permission;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;


class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Gate::before(function($user)
        {
            if($user->isSuperAdmin())
            {
                return true;
            }

        });

        try {
            $permissions = Permission::all();
            foreach($permissions as $permission)
            {
                Gate::define($permission->name,function($user) use ($permission)
                {
                    $temp = json_decode($user->findRole->permissions);
                    return  in_array($permission->name,$temp);
                });
            }

        } catch (\Exception $e) {

            return [];
        }
    }
}
