<?php

namespace App\Http\Controllers;

use App\Models\Allowance;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class AllowanceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index(){
        return view('allowances.index');
    }

    public function showAllAllownces(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2=> 'description',
            3=> 'percentage',
            4=> 'status',
        );

        $totalDataRecord = Allowance::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'allowances.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Allowance::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  Allowance::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('description', 'LIKE',"%{$search_text}%")
                ->orWhere('percentage', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Allowance::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('description', 'LIKE',"%{$search_text}%")
                ->orWhere('percentage', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $dataedit =  route('edit.allowance',['id'=>$id]);
                $status = ($post_val->status == 1)?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>In-Active</span>";
                $desc = (strlen($post_val->description) >50 )?substr($post_val->description,0,100)." ...":$post_val->description;

                $delete_allowance = Gate::allows("delete.allowance")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_allowance = Gate::allows("edit.allowance")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['description'] = $desc;
                $postnestedData['percentage'] = $post_val->percentage;
                $postnestedData['status'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_allowance}  {$delete_allowance}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        return view('allowances.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required|string',
            'description'   => 'required|string',
            'percentage'    => 'required',
            'status'        => 'required',
        ]);

        Allowance::create($request->all());
        return redirect()->route('allowance')->with('mesg','Allowance created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $allowance = Allowance::find($id);
        if ($allowance){
            return view('allowances.edit',compact('allowance'));
        }else{
            return redirect()->back()->with('error','Allowance not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required|string',
            'description'   => 'required|string',
            'percentage'    => 'required',
            'status'        => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $allowance = Allowance::find($request->id);
        if ($allowance){
            $allowance->update($request->all());
            return redirect()->route('allowance')->with('mesg','Allowance updated successfully.');
        }else{
            return redirect()->back()->with('error','Allowance not found.');
        }
    }

    public function delete($id){
        $id = base64_decode($id);
        $allowance = Allowance::find($id);
        if ($allowance){
            $allowance->delete();
            return response('Allowance deleted successfully.');
        }else{
            return response('Allowance not found.');
        }
    }

}
