<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Project extends Model
{
    use HasFactory,SoftDeletes, Sluggable;
    protected $guarded = ['_token'];

    public function findAccountManager(){
        return $this->belongsTo(User::class, 'account_manager_user_id');
    }

    public function findProjectManager(){
        return $this->belongsTo(User::class, 'project_manager_user_id');
    }

    public function findClient(){
        return $this->belongsTo(User::class, 'client_id');
    }

    public function findProjectStatus(){
        return $this->belongsTo(ProjectStatus::class, 'status_id');
    }

    public function findType(){
        return $this->belongsTo(ProjectType::class, 'project_type_id');
    }

    public function findComments(){
        return $this->belongsTo(ProjectComment::class, 'project_id');
    }

    public function projecttouser(){
        return $this->belongsTo(ProjectToUser::class, 'project_id');
    }

    public function getProjectMembers($project_id){
        $users = [];
        $temp_users =  DB::table('project_to_users')->where('project_id', $project_id)->get();
        foreach ($temp_users as $user){
            $users[] = $user->user_id;
        }
        return $users;
    }

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'project_name'
            ]
        ];
    }
}
