<?php

namespace App\Providers;

use App\Models\Loan;
use App\Models\Notification;
use App\Models\NotificationSend;
use App\Models\UserLoginDetails;
use Carbon\Carbon;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        view()->composer('*', function ($view) {

            if (isset(auth()->user()->id)){
                $otherNotifications = Notification::where('to_user_id',auth()->user()->id)->where(function ($query){
                    $query->where('notification_type','Leave Request')
                           ->orWhere('notification_type','Loan Request');
                })->where('is_read',0)->take(5)->get();

                /*$notifications = Notification::whereHas('sentNotification', function ($query){
                    $query->where('to_send',auth()->user()->id)
                        ->where('is_read',0);
                })->orderBy('created_at','desc')->take(5)->get();*/

                $notifications = NotificationSend::where('to_send' ,auth()->id())->with('gnotification')
                    ->orderBy('created_at','desc')
                    ->take(5)->get();

                $un_read = Notification::whereHas('sentNotification', function ($query){
                    $query->where('to_send',auth()->user()->id)
                        ->where('is_read',0);
                })->orWhere(function ($query){
                    $query->where('to_user_id',auth()->user()->id)
                        ->where('notification_type','!=','General Notification')
                        ->where('is_read',0);
                })->count();

                $new_loan_request_count = Loan::where('status', 'Pending')->count();

                $view->with('notifications', $notifications)
                    ->with('otherNotifications', $otherNotifications)
                    ->with('un_read', $un_read)
                    ->with('new_loan_request_count', $new_loan_request_count);

                    $loginDetailsModel = new UserLoginDetails();
                    $log_id = $loginDetailsModel->verify_check(auth()->user());
                    session()->put('log_id', $log_id);

                }
//                dd(auth()->user());
//                $view->with("log_id",$log_id);
        });
    }
}
