<!-- Left sidebar -->
<aside id="basicSidebar"
       class="pmd-sidebar pmd-sidebar-dark pmd-sidebar-slide-push pmd-sidebar-open bg-primary pmd-z-depth-light-2"
       role="navigation">
    <ul class="nav flex-column pmd-sidebar-nav">

        <!-- User info -->
        <li class="nav-item pmd-user-info mb-0">
            <a href="javascript:void(0);" class="nav-link btn-user text-center">
                @if(auth()->user()->image)
                    <img class="rounded-circle m-auto" src="{{asset('employees/images/'.(auth()->user()->image))}}" width="40" height="40"
                         alt="avatar">
                @else
                    <img class="rounded-circle m-auto" src="{{asset('themes/images/user-icon.jpg')}}" width="40" height="40"
                         alt="avatar">
                @endif
                <h3 class="pmd-title m-0">{{ auth()->user()->name ?? 'Propeller Admin' }}</h3>
                <p class="pmd-subheading1 m-0">{{ auth()->user()->email ?? 'support@propeller.in' }}</p>
            </a>
        </li>
        <!-- End user info -->

        <li class="nav-item">
            <a class="nav-link pmd-ripple-effect" href="{{route('dashboard')}}">
                <i class="pmd-list-icon fa fa-dashboard"></i>
                <span class="media-body">Dashboard</span>
            </a>
        </li>

        @can('project')

            <?php
            $collapsed = '';
            if (Request::is('site/project') || Request::is('site/project/create') || Request::is('site/project*')) {
                $collapsed = 'show';
            }elseif (Request::is('site/project-status') || Request::is('site/project-status/create')) {
                $collapsed = 'show';
            }elseif (Request::is('site/project-type') || Request::is('site/project-type/create')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#project-menu">
                    <i class="pmd-list-icon fa fa-bar-chart"></i>
                    <span class="media-body">Team Work</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="project-menu" data-parent="#basicSidebar">
                    @can('project')
                        <li class="nav-item {{ Request::is('site/project') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('project')}}">Project List</a>
                        </li>
                    @endcan
                    @can('project-type')
                        <li class="nav-item {{ Request::is('site/project-type') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('project-type')}}">Project Type List</a>
                        </li>
                    @endcan
                    @can('project-status')
                        <li class="nav-item {{ Request::is('site/project-status') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('project-status')}}">Project Status List</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('client')

            <?php
            $collapsed = '';
            if (Request::is('site/client') || Request::is('site/client/create') || Request::is('site/client*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#client-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Clients</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="client-menu" data-parent="#basicSidebar">
                    @can('client')
                        <li class="nav-item {{ Request::is('site/client') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('client')}}">Client List</a>
                        </li>
                    @endcan
                    @can('create.client')
                        <li class="nav-item {{ Request::is('site/client/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.client')}}">Create Client</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('user')

            <?php
            $collapsed = '';
            if (Request::is('site/user') || Request::is('site/user/create') || Request::is('site/user/edit*') || Request::is('site/user/user-activity')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#employee-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Employees</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="employee-menu" data-parent="#basicSidebar">
                    @can('user')
                        <li class="nav-item {{ Request::is('site/user') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('user')}}">Employee List</a>
                        </li>
                    @endcan
                    @can('create.user')
                        <li class="nav-item {{ Request::is('site/user/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.user')}}">Create Employee</a>
                        </li>
                    @endcan
                    @can('user.activity')
                        <li class="nav-item {{ Request::is('site/user/user-activity') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('user.activity')}}">Employee Attendance Activity</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('employee-salary')

            <?php
            $collapsed = '';
            if (Request::is('site/employee-salary') || Request::is('site/employee-salary/create') || Request::is('site/employee-salary*')) {
                $collapsed = 'show';
            }
            ?>

            <li class="nav-item {{ Request::is('site/employee-salary') ? 'nav-border' : '' }}">
                <a class="nav-link pmd-ripple-effect" href="{{route('employee-salary')}}">
                    <i class="pmd-list-icon fas fa-money-bill"></i>
                    <span class="media-body">Salaries</span>
                </a>
            </li>

        @endcan

        @can('loan')

            <?php
            $collapsed = '';
            if (Request::is('site/loan') || Request::is('site/loan/*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#loan-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">Loans
                        @if((auth()->user()->is_admin??'') && $new_loan_request_count > 0) {{"(".$new_loan_request_count.")"}} @endif
                    </span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="loan-menu" data-parent="#basicSidebar">
                    @can('loan')

                        <li class="nav-item {{ Request::is('site/loan/requests') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('loan.pending')}}">
                                @if(auth()->check() && auth()->user()->is_admin)
                                    New Requests
                                @else
                                    Pending Requests
                                @endif

                                @if((auth()->user()->is_admin??'') && $new_loan_request_count > 0) {{"(".$new_loan_request_count.")"}} @endif
                            </a>
                        </li>

                        <li class="nav-item {{ Request::is('site/loan') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('loan')}}">Loan List</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('user-status')

            <?php
            $collapsed = '';
            if (Request::is('site/user-status') || Request::is('site/user-status/create') || Request::is('site/user-status*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#user-status-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">User Status</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="user-status-menu" data-parent="#basicSidebar">
                    @can('user-status')
                        <li class="nav-item {{ Request::is('site/user-status') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('user-status')}}">User Status List</a>
                        </li>
                    @endcan
                    @can('create.user-status')
                        <li class="nav-item {{ Request::is('site/user-status/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.user-status')}}">Create User Status</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('user-department')

            <?php
            $collapsed = '';
            if (Request::is('site/user-department') || Request::is('site/user-department/create') || Request::is('site/user-department*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#user-designation-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">User Department</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="user-designation-menu" data-parent="#basicSidebar">
                    @can('user-department')
                        <li class="nav-item {{ Request::is('site/user-department') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('user-department')}}">User Department List</a>
                        </li>
                    @endcan
                    @can('create.user-department')
                        <li class="nav-item {{ Request::is('site/user-department/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.user-department')}}">Create User Department</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('job-title')

            <?php
            $collapsed = '';
            if (Request::is('site/job-title') || Request::is('site/job-title/create') || Request::is('site/job-title*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#job-title-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">Job Title</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="job-title-menu" data-parent="#basicSidebar">
                    @can('job-title')
                        <li class="nav-item {{ Request::is('site/job-title') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('job-title')}}">Job Title List</a>
                        </li>
                    @endcan
                    @can('create.job-title')
                        <li class="nav-item {{ Request::is('site/job-title/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.job-title')}}">Create Job Title</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('allowance')
            <?php
            $collapsed = '';
            if (Request::is('site/allowance') || Request::is('site/allowance/create') || Request::is('site/allowance*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#allowance-menu">
                    <i class="pmd-list-icon fa fa-usd"></i>
                    <span class="media-body">Allowances</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="allowance-menu" data-parent="#basicSidebar">
                    @can('allowance')
                        <li class="nav-item {{ Request::is('site/allowance') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('allowance')}}">Allowance List</a>
                        </li>
                    @endcan
                    @can('create.allowance')
                        <li class="nav-item {{ Request::is('site/allowance/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.allowance')}}">Create Allowance</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('role')
            <?php
            $collapsed = '';
            if (Request::is('site/role') || Request::is('site/role/create') || Request::is('site/role*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#role-menu">
                    <i class="pmd-list-icon fa fa-shield"></i>
                    <span class="media-body">Roles</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="role-menu" data-parent="#basicSidebar">
                    @can('role')
                        <li class="nav-item {{ Request::is('site/role') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('role')}}">Role List</a>
                        </li>
                    @endcan
                    @can('create.role')
                        <li class="nav-item {{ Request::is('site/role/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.role')}}">Create Role</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('permission')
            <?php
            $collapsed = '';
            if (Request::is('site/permission') || Request::is('site/permission/create') ) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#permission-menu">
                    <i class="pmd-list-icon fa fa-key"></i>
                    <span class="media-body">Permissions</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="permission-menu" data-parent="#basicSidebar">
                    @can('permission')
                        <li class="nav-item {{ Request::is('site/permission') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('permission')}}">Permission List</a>
                        </li>
                    @endcan
                    @can('create.permission')
                        <li class="nav-item {{ Request::is('site/permission/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.permission')}}">Create Permission</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('ip')
            <?php
            $collapsed = '';
            if (Request::is('site/ip') || Request::is('site/ip/create') || Request::is('site/ip*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#ip-menu">
                    <i class="pmd-list-icon fa fa-globe"></i>
                    <span class="media-body">IP Management</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="ip-menu" data-parent="#basicSidebar">
                    @can('ip')
                        <li class="nav-item {{ Request::is('site/ip') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('ip')}}">Ip List</a>
                        </li>
                    @endcan
                    @can('create.ip')
                        <li class="nav-item {{ Request::is('site/ip/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.ip')}}">Create Ip</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('shift')
            <?php
            $collapsed = '';
            if (Request::is('site/shift') || Request::is('site/shift/create') || Request::is('site/shift*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#shift-menu">
                    <i class="pmd-list-icon fa fa-clock-o"></i>
                    <span class="media-body">Shifts</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="shift-menu" data-parent="#basicSidebar">
                    @can('shift')
                        <li class="nav-item {{ Request::is('site/shift') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('shift')}}">Shift List</a>
                        </li>
                    @endcan
                    @can('create.shift')
                        <li class="nav-item {{ Request::is('site/shift/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.shift')}}">Create Shift</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('leave')
            <?php
            $collapsed = '';
            if (Request::is('site/leave') || Request::is('site/leave/create') || Request::is('site/leave/edit/*') ) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#leave-menu">
                    <i class="pmd-list-icon fa fa-wheelchair-alt"></i>
                    <span class="media-body">Leave Types</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="leave-menu" data-parent="#basicSidebar">
                    @can('leave')
                        <li class="nav-item {{ Request::is('site/leave') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('leave')}}">Leave Type List</a>
                        </li>
                    @endcan
                    @can('create.leave')
                        <li class="nav-item {{ Request::is('site/leave/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.leave')}}">Create Leave Type</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('team')
            <?php
            $collapsed = '';
            if (Request::is('site/team') || Request::is('site/team/create') || Request::is('site/team*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#team-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Teams</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="team-menu" data-parent="#basicSidebar">
                    @can('team')
                        <li class="nav-item {{ Request::is('site/team') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('team')}}">Team List</a>
                        </li>
                    @endcan
                    @can('create.team')
                        <li class="nav-item {{ Request::is('site/team/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.team')}}">Create Team</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('rank')
            <?php
            $collapsed = '';
            if (Request::is('site/rank') || Request::is('site/rank/create') || Request::is('site/rank*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#rank-menu">
                    <i class="pmd-list-icon fa fa-level-up"></i>
                    <span class="media-body">Ranks</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="rank-menu" data-parent="#basicSidebar">
                    @can('rank')
                        <li class="nav-item {{ Request::is('site/rank') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('rank')}}">Rank List</a>
                        </li>
                    @endcan
                    @can('create.rank')
                        <li class="nav-item {{ Request::is('site/rank/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.rank')}}">Create Rank</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('taxslab')
            <?php
            $collapsed = '';
            if (Request::is('site/taxslab') || Request::is('site/taxslab/create') || Request::is('site/taxslab*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#taxslab-menu">
                    <i class="pmd-list-icon fa fa-bank"></i>
                    <span class="media-body">Tax Management</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="taxslab-menu" data-parent="#basicSidebar">
                    @can('taxslab')
                        <li class="nav-item {{ Request::is('site/taxslab') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('taxslab')}}">Tax Slab List</a>
                        </li>
                    @endcan
                    @can('create.taxslab')
                        <li class="nav-item {{ Request::is('site/taxslab/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.taxslab')}}">Create Tax Slab</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('leave-management')
            <?php
            $collapsed = '';
            if (Request::is('site/leave-management') || Request::is('site/leave-management/create') || Request::is('site/leave-management*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#leave-management">
                    <i class="pmd-list-icon fa fa-calendar"></i>
                    <span class="media-body">Leave Requests</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="leave-management" data-parent="#basicSidebar">
                    @can('leave-management')
                        <li class="nav-item {{ Request::is('site/leave-management') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('leave-management')}}">All Requests</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('notification')
            <?php
            $collapsed = '';
            if (Request::is('site/notification') || Request::is('site/notification/create') || Request::is('site/notification/sent') || Request::is('site/notification*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#notification">
                    <i class="pmd-list-icon fa fa-bell"></i>
                    <span class="media-body">Notification</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="notification" data-parent="#basicSidebar">
                    @can('sent.notification')
                        <li class="nav-item {{ Request::is('site/notification/sent') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('sent.notification')}}">Sent Notifications</a>
                        </li>
                    @endcan
                    @can('received.notification')
                        <li class="nav-item {{ Request::is('site/notification/received') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('received.notification')}}">Received Notifications</a>
                        </li>
                    @endcan
                    @can('create.notification')
                        <li class="nav-item {{ Request::is('site/notification/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.notification')}}">Create Notification</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        @can('interview')

            <?php
            $collapsed = '';
            if (Request::is('site/interview') || Request::is('site/interview/create') || Request::is('site/interview*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#interview-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Interview</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse {{ $collapsed }}" id="interview-menu" data-parent="#basicSidebar">
                    @can('interview')
                        <li class="nav-item {{ Request::is('site/interview') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('interview')}}">Interview List</a>
                        </li>
                    @endcan
                    @can('create.interview')
                        <li class="nav-item {{ Request::is('site/interview/create') ? 'nav-border' : '' }}">
                            <a class="nav-link" href="{{route('create.interview')}}">Create Interview</a>
                        </li>
                    @endcan
                </ul>
            </li>
        @endcan

        <li class="nav-item">
            {{--<a class="nav-link" data-toggle="collapse" href="#logout-menu">
                <i class="pmd-list-icon fa fa-sign-out"></i>
                <span class="media-body">Logout</span>
                <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
            </a>--}}
            <a class="nav-link" id="logout_area">
                <i class="pmd-list-icon fa fa-power-off"></i>
                <span class="media-body" id="logout_btn">Logout</span>
                <form action="{{route('logout', ['logout_type' => 'Normal Logout'])}}" method="post" id="logout_form">
                    @csrf
                </form>
            </a>
            <ul class="collapse" id="logout-menu" data-parent="#basicSidebar">
                @if(auth()->check() && auth()->user()->is_admin)
                    <li class="nav-item" style="color: white">
                        <a class="nav-link" id="logout_area">
                            <i class="pmd-list-icon fa fa-power-off"></i>
                            <span class="media-body" id="logout_btn">Logout</span>
                            <form action="{{route('logout')}}" method="post" id="logout_form">
                                @csrf
                            </form>
                        </a>
                    </li>
                @else
                  {{--  <li class="nav-item" style="color: white">
                        <a class="nav-link" id="logout_area">
                            <i class="pmd-list-icon fa fa-power-off"></i>
                            <span class="media-body" id="logout_btn">Normal Logout</span>
                            <form action="{{route('logout', ['logout_type' => 'Normal Logout'])}}" method="post" id="logout_form">
                                @csrf
                            </form>
                        </a>
                    </li>
                    <li class="nav-item" style="color: white">
                        <a class="nav-link pmd-ripple-effect" id="logout_area2">
                            <i class="pmd-list-icon fa fa-power-off"></i>
                            <span class="media-body" id="logout_btn">Shift Logout</span>
                            <form action="{{route('logout', ['logout_type' => 'Shift Logout'])}}" method="post" id="logout_form2">
                                @csrf
                            </form>
                        </a>
                    </li>--}}
                @endif
            </ul>
        </li>

    </ul>
</aside>
<!-- End Left sidebar -->

@push('js')
    <script>
        $('#logout_area').on('click', function () {
            $('#logout_form').submit()
        })

        $('#logout_area2').on('click', function () {
            $('#logout_form2').submit()
        })
    </script>
@endpush
