@extends('layouts.app')
@section('page-title','Make Request')

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Leave Requests</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.leave-management')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="leave_type_id" class="col-form-label control-label">Leave Type</label>
                                            <select name="leave_type_id" id="leave_type_id" class="form-control" required>
                                                <option></option>
                                                @foreach($leave_types as $leave_type)
                                                <option value="{{$leave_type->id}}">{{$leave_type->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('leave_type_id')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="leave_from_date" class="col-form-label control-label">Start Date</label>
                                            <input type="text" class="form-control" name="leave_from_date" min="0"
                                                   aria-describedby="emailHelp" id="datepickerstart" value="{{old('leave_from_date')}}" required>
                                            @error('leave_from_date')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="leave_end_date" class="col-form-label control-label">End Date</label>
                                            <input type="text" class="form-control" name="leave_end_date" min="0"
                                                   aria-describedby="emailHelp" id="datepickerend" value="{{old('leave_end_date')}}" required>
                                            @error('leave_end_date')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="reason" class="col-form-label control-label">Reason</label>
                                            <textarea id="reason" class="form-control" rows="5" name="reason" required>{{old('reason')}}</textarea>
                                            @error('reason')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <div class="row">
                                <div class="offset-md-3 col-md-6">
                                    <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        var dateToday = new Date();
        // Add start date date and time picker
        $('#datepickerstart').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });

        // Add End date date and time picker
        $('#datepickerend').datetimepicker({
            useCurrent: false,
            format: 'DD-MM-YYYY'
        });

        // start date picker
        $("#datepickerstart").on("dp.change", function (e) {
            $('#datepickerend').data("DateTimePicker").minDate(e.date);
        });
        // end date picker
        $("#datepickerend").on("dp.change", function (e) {
            $('#datepickerstart').data("DateTimePicker").maxDate(e.date);
        });
    </script>
@endpush
