@extends('layouts.app')
@section('page-title','Create Permissions')

@push('css')
    <style>
        .outer-ul li {
            list-style: none;
            font-weight: bolder;
            color: #797979;
        }
        .outer-ul > li {
            margin-bottom: 2px;
        }
        .outer-div {
            background-color: #e6e6e6;
            border-radius: 5px;
            padding: 20px 0px 0px 10px;
            margin-bottom: 10px;
            margin-right: 10px;
        }
    </style>
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrum start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Permissions</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrum end-->
        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.permission')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">

                            <div class="details-tab">

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <div class="row">
                                                @error('permissions')
                                                <div class="col-md-12">
                                                    <span><strong class="text-danger">Please select few permissions.</strong></span>
                                                </div>
                                                @enderror()
                                                @foreach($groupRoutes as $key => $route)
                                                    <div class="col-sm-3 outer-div" style="flex: 0 0 25%; max-width: 23%">
                                                        <ul class="outer-ul">
                                                            <li style="margin: 0px -20px 0 -45px; padding: 10px"><input type="checkbox" class="check-permission mr-1 check-all-child-boxes" >{{ ucfirst($key) }}
                                                                <ul class="inner-ul">
                                                                    @foreach($route as $value)
                                                                        @if(in_array($value,$permissions)) @continue @endif
                                                                        <li><input type="checkbox" name="permissions[]" value="{{$value}}" class="check-permission mr-1" >{{$value}}</li>
                                                                    @endforeach
                                                                </ul>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        $(document).on('click','.check-all-child-boxes',function(){

            if($(this).prop('checked')){
                $(this).parents('li').find('.check-permission').prop('checked',true);
            }else{
                $(this).parents('li').find('.check-permission').prop('checked',false);
            }
        });

        $(document).on('click','.check-permission',function(){

            if($(this).prop('checked')){

                var count = 0
                $(this).parents('ul:eq(0)').find('.check-permission').each(function(){
                    if($(this).prop('checked')){
                        count++;
                    }
                })

                if(count){
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',true)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',true)
                }else{
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',false)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',false)
                }

            }else{

                var count = 0
                $(this).parents('ul:eq(0)').find('.check-permission').each(function(){
                    if($(this).prop('checked')){
                        count++;
                    }
                })

                if(count > 1){
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',true)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',true)

                }else{
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',false)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',false)
                }
            }
        });
    </script>
@endpush
