@extends('layouts.app')
@section('page-title','Update Rank')

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Ranks</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('update.rank')}}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{base64_encode($rank->id)}}">
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="title" class="col-form-label control-label">Rank Title</label>
                                            <input type="text" class="form-control" name="title"
                                                   aria-describedby="emailHelp" id="title" value="{{$rank->title ?? old('title')}}" required>
                                            @error('title')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status" class="col-form-label control-label">Status</label>
                                            <select name="status" id="status" class="form-control" required>
                                                <option></option>
                                                <option value="1" @if($rank->status == 1) selected @endif>Active</option>
                                                <option value="0" @if($rank->status == 0) selected @endif>In-Active</option>
                                            </select>
                                            @error('status')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
