@extends('layouts.app')
@section('page-title','Create Tax Slab')

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Tax Management</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.taxslab')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="title" class="col-form-label control-label">Slab Title</label>
                                            <input type="text" class="form-control" name="title"
                                                   aria-describedby="emailHelp" id="title" value="{{old('title')}}" required>
                                            @error('title')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="min_amount" class="col-form-label control-label">Minimum Amount (Yearly)</label>
                                            <input type="number" class="form-control format_currency" name="min_amount" min="0"
                                                   aria-describedby="emailHelp" id="min_amount" value="{{old('min_amount')}}" required>
                                            @error('min_amount')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="max_amount" class="col-form-label control-label">Maximum Amount (Yearly)</label>
                                            <input type="number" class="form-control" name="max_amount" min="0"
                                                   aria-describedby="emailHelp" id="max_amount" value="{{old('max_amount')}}" required>
                                            @error('max_amount')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="tax_percentage" class="col-form-label control-label">Tax Percentage (%)</label>
                                            <input type="number" class="form-control" name="tax_percentage" min="0" step=".5"
                                                   aria-describedby="emailHelp" id="tax_percentage" value="{{old('tax_percentage')}}" required>
                                            @error('tax_percentage')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fixed_deduction" class="col-form-label control-label">Fixed Deduction (If applicable)</label>
                                            <input type="number" class="form-control" name="fixed_deduction" min="0"
                                                   aria-describedby="emailHelp" id="fixed_deduction" value="{{old('fixed_deduction')}}" required>
                                            @error('fixed_deduction')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="description" class="col-form-label control-label">Description</label>
                                            <textarea id="description" class="form-control" rows="5" name="description">{{old('description')}}</textarea>
                                            @error('description')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status" class="col-form-label control-label">Status</label>
                                            <select name="status" id="status" class="form-control" required>
                                                <option value="" hidden></option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                            @error('status')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
                <div class="card pmd-card">
                    <div class="card-body">

                        <div class="details-tab">
                            <div class="row">
                                <div class=" col-12 col-sm-6 col-md-6">
                                    <h3>Important Information</h3>
                                </div>
                            </div>

                            <div class="row">
                                <div class=" col-12 col-sm-6 col-md-6">
                                    <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                                        <tbody>
                                            <tr>
                                                <th>Minimum Amount</th>
                                                <td>Refers to the minimum annual income that falls in the slab category</td>
                                            </tr>
                                            <tr>
                                                <th>Maximum Amount</th>
                                                <td>Refers to the maximum annual income that falls in the slab category</td>
                                            </tr>
                                            <tr>
                                                <th>Fixed Deduction</th>
                                                <td>Refers to the amount that is added to calculation besides tax after exceeding certain range</td>
                                            </tr>
                                            <tr>
                                                <td colspan="2">
                                                    <strong class="text-danger">NOTE: </strong>
                                                    Please visit FBR Official site for latest
                                                    <strong><a href="https://fbr.gov.pk/withholding-tax-rates/51147/81155">Tax Slabs Information</a></strong></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="mt-5 col-12 col-sm-6 col-md-12">
                                    <h3>Additional Links</h3>
                                </div>
                                <div class=" col-12 col-sm-6 col-md-6">
                                    <a href="https://taxcalculator.pk/">Tax Calculator</a>
                                    <br>
                                    <a href="https://fbr.gov.pk/withholding-tax-rates/51147/81155">FBR Withholding Tax Rates</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script>
        // $('.format_currency').mask('000.000.000.000.000,00', {reverse: true});
    </script>
@endpush
