@extends('layouts.app')
@section('page-title','Update Client')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Clients</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('update.client')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{$client->id}}">
                        <div class="card-body">
                            <!-- Upload Picture -->
                            <div class="details-tab">
                                <h3 class="card-title mb-3">Profile Picture</h3>
                                <div data-provides="fileinput" class="fileinput fileinput-new">
                                    <div data-trigger="fileinput" class="fileinput-preview thumbnail img-fluid rounded-circle mb-0">
                                        @if($client->gender == 'Male')
                                            <img alt="Profile-Pic" src="{{asset(isset($client->image) ? 'employees/images/'.$client->image : 'themes/images/dummy.png')}}" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        @else
                                            <img alt="Profile-Pic" src="{{asset(isset($client->image) ? 'employees/images/'.$client->image : 'themes/images/dummy-female.png')}}" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        @endif
                                    </div>
                                    <div class="action-button">
                                        <span class="btn btn-secondary pmd-btn-fab btn-sm pmd-btn-raised btn-file pmd-ripple-effect">
                                            <span class="fileinput-new"><i class="material-icons pmd-xs">add</i></span>
                                            <span class="fileinput-exists"><i class="material-icons pmd-xs">mode_edit</i></span>
                                            <input type="file" name="file">
                                        </span>
                                        <a data-dismiss="fileinput" class="btn btn-danger btn-sm pmd-btn-fab pmd-ripple-effect pmd-btn-raised btn-file fileinput-exists" href="javascript:void(0);"><i class="material-icons pmd-sm">close</i></a>
                                    </div>
                                </div>
                            </div>

                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Client Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">First Name</label>
                                            <input type="text" class="form-control" name="firstname"
                                                   aria-describedby="emailHelp" id="fn" value="{{old('firstname')??$client->firstname}}" required>
                                            @error('firstname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Last Name</label>
                                            <input type="text" class="form-control" name="lastname" id="ln"
                                                   aria-describedby="emailHelp" value="{{old('lastname')??$client->lastname}}" required>
                                            @error('lastname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="{{old('phone')??$client->phone}}" required>
                                            @error('phone')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="{{old('email')??$client->email}}" required>

                                            @error('email')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <label for="email" class="d-block title-label">Gender</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="male" name="gender" class="custom-control-input" value="Male"
                                                   @if($client->gender == 'Male') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="male">Male</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="female" name="gender" class="custom-control-input" value="Female"
                                                   @if($client->gender == 'Female') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="female">Female</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="marital" class="d-block title-label">Marital Status</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="married" name="marital_status" class="custom-control-input" value="Married"
                                                   @if($client->marital_status == 'Married') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="married">Married</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="unmarried" name="marital_status" class="custom-control-input" value="Unmarried"
                                                   @if($client->marital_status == 'Unmarried') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="unmarried">Unmarried</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="role">Role Permission</label>
                                            <select name="role_id" id="role_id" class="form-control " required>
                                                <option value="" hidden></option>
                                                @forelse($roles as $role)
                                                    <option value="{{$role->id}}"
                                                            @if($client->findRole) @if($client->findRole->name == $role->name) selected @endif @endif>{{$role->name}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('role_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status_id">Status</label>
                                            <select name="status_id" id="status_id" class="form-control" >
                                                <option></option>
                                                @foreach($status as $st)
                                                    <option value="{{$st->id}}" @if($client->status_id == $st->id) selected @endif>{{$st->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('status')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
        });

        var dateToday = new Date();
        // Add start date date and time picker
        $('#datepickerjoin').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });


    </script>
@endpush
