@extends('layouts.app')
@section('page-title','Interviews')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css"/>
@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrum start-->
        <div class="float-right @cannot('create.interview') no-btn @endcannot" >
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>

            </nav>
        </div>
        <div>
            @can('create.interview')
                <a href="{{route('create.interview')}}" class="btn btn-primary ">Create</a>
            @endcan
        </div>

        <!--breadcrum end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <input type="hidden" id="id_delete">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                        <thead class="thead-light">

                        <tr>
                            <th>S No.</th>
                            <th>Candidate</th>
                            <th>Father's Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Department</th>
                            <th>Job Title</th>
                            <th>Cv Resume</th>
                            <th>Cover Letter</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>


                    </tbody>
                </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')

    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
    <script>
        $(document).ready( function () {

            $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "{{ route('show.interview.list') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "{{csrf_token()}}"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "name",sortable: false},
                    {"data": "fathername",sortable: false},
                    {"data": "email",sortable: false},
                    {"data": "phone",sortable: false},
                    {"data": "department",sortable: false},
                    {"data": "applied_for",sortable: false},
                    {"data": "resume",sortable: false},
                    {"data": "cover_letter",sortable: false},
                    {"data": "status_id",sortable: false},
                    {"data": "options",sortable: false}
                ]
            });
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/interview/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
