@extends('layouts.app')
@section('page-title','Roles')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.role') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.role')
                <a href="{{route('create.role')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Role name</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 1; @endphp
                            @forelse($roles as $role)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{$role->name}}</td>
                                    <td>
                                        @if($role->status == 1)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-danger">In-Active</span>
                                        @endif
                                    </td>
                                    <td>
                                        @can('show.role')
                                            {{--<a class="btn btn-success btn-style" href="{{route('show.role',base64_encode($role->id)))}}"><i class="fa fa-eye"></i> view</a>--}}
                                        @endcan
                                        @can('edit.role')
                                            <a class="btn btn-primary btn-style" href="{{route('edit.role',base64_encode($role->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                        @endcan
                                        {{--<button class="btn btn-danger delete-btn" data-id="{{base64_encode($role->id))}}"><i class="fa fa-trash"></i> delete</button>--}}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" align="center">No Roles Available</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>
        $(document).ready( function () {
            $('#roles-datatable').DataTable();
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/role/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
