<?php $__env->startSection('page-title',$team_member->title); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right no-btn">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>

        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <input type="hidden" name="team_id" id="team_id" value="<?php echo e($team_member->id??''); ?>">
                    <div class="d-flex justify-content-end">
                        <button class="btn btn-primary disbursed"><i></i> Disburse</button>
                    </div>
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Name</th>
                                <th>Basic Salary</th>
                                <th>Medical Allowance</th>
                                <th>Transportation Allowance</th>
                                <th>Mobile Allowance</th>
                                <th>Working Days</th>
                                <th>Total Salary</th>
                                <th>Tax</th>
                                <th>Overtime (Hours)</th>
                                <th>Bonus</th>
                                <th>Payable Salary</th>
                                <th>Disbursed Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Other Calculations <span id="total-payable-salary">Total Payable : 120000</span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body notification-list-scroll">
                    <div class="row pl-3 notification-list-view" >
                        <div class="col-sm-6">
                            <label class="form-check-label" for="inlineRadio1"><b>Late In</b></label>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-check form-check-inline pl-3">
                                <input class="form-check-input" type="checkbox" name="late_in" id="late_in" value="yes" />
                                <label class="form-check-label " for="late_in">yes</label>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <label class="form-check-label" for="inlineRadio1"><b>Early Out</b></label>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-check form-check-inline pl-3" >
                                <input class="form-check-input" type="checkbox" name="early_out" id="early_out" value="yes" />
                                <label class="form-check-label" for="early_out">Yes</label>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <label class="form-check-label" for="inlineRadio1"><b>Unpaid Leaves</b></label>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-check form-check-inline pl-3">
                                <input class="form-check-input" type="checkbox" name="unpaid_leaves" id="unpaid_leaves" value="yes" />
                                <label class="form-check-label" for="unpaid_leaves">Yes</label>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <label for="overtime_hours" class="form-label"><b>Overtime : <span id="overtime-total" title="Total overtime"></span></b></label>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-check form-check-inline pl-3">
                                <input class="form-control" type="number" name="overtime_hours" id="overtime_hours" min="0" placeholder="Overtime (Hours)" />

                            </div>
                        </div>

                        <div class="col-sm-6">
                            <label for="bonus_amount" class="form-label"><b>Bonus</b></label>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-check form-check-inline pl-3">
                                <input class="form-control" type="number" name="bonus_amount" id="bonus_amount" min="0" placeholder="Bonus (Rs.)" />
                            </div>
                        </div>
                    </div>
                    <div class="row pl-3 notification-list-view loan_status" >

                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <span class="save_changes"></span>
                            <button type="button" class="btn btn-secondary generated_salaries" >Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('js/jquery-mask/src/jquery.mask.js')); ?>"></script>
    <script>
        var team_id;
        $(document).ready(function () {
            team_id =  $('#team_id').val();

            var dataTables =  $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "<?php echo e(route('show.team.employee.salary')); ?>",
                    "dataType": "json",
                    "type": "POST",
                    "data":function (data) {
                        data._token = "<?php echo e(csrf_token()); ?>";
                        data.id = team_id;
                    }
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "name",sortable: false},
                    {"data": "basic_salary",sortable: false},
                    {"data": "medical_allowance",sortable: false},
                    {"data": "transportation_allowance",sortable: false},
                    {"data": "mobile_allowance",sortable: false},
                    {"data": "working_days",sortable: false},
                    {"data": "total_salary",sortable: false},
                    {"data": "salary_tax",sortable: false},
                    {"data": "over_time",sortable: false},
                    {"data": "bonus_amount",sortable: false},
                    {"data": "net_salary",sortable: false},
                    {"data": "disbursed-status",sortable: false},
                    {"data": "yes_no_fields",sortable: false},
                ]
            });
        });
        var user_id;
        $(document).on('click','.yes_no_fields',function () {
            $('.save_changes').text('');
            $('#overtime-total').text('');
            $('.save_changes').removeClass('text-success');
            $('.save_changes').removeClass('text-danger');
            let ele = $(this)
            let total_salary = ele.attr('data-total')
            user_id = $(this).attr('data-id');

            $('#total-payable-salary').text("( Total Payable : "+total_salary+")")

            $.ajax({
                url: '<?php echo e(URL::to('site/employee-salary/show-generated-salary')); ?>' +"/"+ user_id,
                type: 'get',
                success: function(response){
                    // console.log(response)
                    if(response.status){

                        var value = response.loans.installment_amount;
                        $('.loan_status').html("<div class='col-sm-6 loan'>" +
                            "    <label class='form-check-label loan_status' for='inlineRadio1'><b>Loan Installment ("+value+")</b></label>" +
                            "</div>" +
                            "<div class='col-sm-6 loan'>" +
                            "    <div class='form-check form-check-inline pl-3'>" +
                            "        <input class='form-check-input' type='checkbox' name='loan' id='loan' value='yes' />" +
                            "        <label class='form-check-label' for='loan'>Yes</label>" +
                            "    </div>" +
                            "</div>")

                        if (response.generated_salary){
                            var loan = response.generated_salary.loan == 1;
                            $('#loan').prop('checked', loan);
                        }else{
                            $('#loan').prop('checked', true);
                        }
                    }else{
                        $('.loan_status').html(' ')
                    }

                    // console.log(response)
                    if(response.generated_salary){
                        let late_in_value = response.generated_salary.late_in == 1;
                        let early_out_value = response.generated_salary.early_out == 1;
                        let unpaid_leaves_value = response.generated_salary.unpaid_leave == 1;
                        let bonus = response.generated_salary.bonus_amount;
                        var overtime_hours = response.generated_salary.overtime_hours;

                        $('#late_in').prop('checked', late_in_value);
                        $('#early_out').prop('checked', early_out_value);
                        $('#unpaid_leaves').prop('checked', unpaid_leaves_value);
                        $('#bonus_amount').val(bonus);
                        $('#overtime_hours').val(overtime_hours);
                        $('#overtime-total').text("("+ele.attr('data-overtime')+" hours)");
                        // $('#overtime').prop('checked', overtime_value);
                    }
                }
            });
        })

        $(document).on('click','.update_disburse',function () {
            var id =$(this).attr('data-id');

            $(document).ajaxStart(function() {
                $("#loading"+id).html("<i class='fa fa-refresh fa-spin mr-2'></i>  Loading");
            }).ajaxStop(function() {
            });

            $.ajax({
                url: '<?php echo e(URL::to('site/employee-salary/update-disburse-status')); ?>',
                data:{
                    'id':id
                },
                type: 'get',
                success: function(response){
                    // console.log('response');
                    location.reload()
                }
            });
        })

        $(document).on('click','.generated_salaries',function () {
            var late_in = $("input[name='late_in']:checked").val()?'1':'0';
            var early_out = $("input[name='early_out']:checked").val()?'1':'0';
            var unpaid_leave = $("input[name='unpaid_leaves']:checked").val()?'1':'0';
            // var overtime = $("input[name='overtime']:checked").val()?'1':'0';
            var overtime_hours = $("#overtime_hours").val();
            var loan = $("input[name='loan']:checked").val()?'1':'0';
            var bonus = $("#bonus_amount").val();

            $.ajax({
                url: '<?php echo e(URL::to('site/employee-salary/generated-salary')); ?>',
                type: 'POST',
                data: {
                    'user_id': user_id,
                    'late_in': late_in,
                    'early_out': early_out,
                    'unpaid_leave': unpaid_leave,
                    // 'overtime': overtime,
                    'overtime_hours': overtime_hours,
                    'bonus_amount': bonus,
                    'loan': loan,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response){
                    // console.log(response)
                    if(response.status === true){
                        $('.save_changes').addClass("text-success");
                        $('.save_changes').text("Changes saved successfully... ");
                        $('input:checkbox').removeAttr('checked');
                        location.reload()
                    }else{
                        $('.save_changes').text("Could not save changes... ");
                        $('.save_changes').addClass("text-danger");
                        $('input:checkbox').removeAttr('checked');
                    }
                }
            });
        })

        $(document).ready(function () {

            $.ajax({
                url: '<?php echo e(URL::to('site/employee-salary/disbursed-status')); ?>',
                type: 'POST',
                data: {
                    'team_id': team_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response){
                    // console.log(response)
                    if(response.user > 0){
                        $(".disbursed").attr("disabled", "disabled");
                        $(".disbursed").html("disbursed");
                    }else{
                        $(".disbursed").removeAttr("disabled");
                    }
                }
            });
        });

        $(document).on('click','.disbursed',function(){

            $(document).ajaxStart(function() {
                $(".disbursed").html("<i class='fa fa-refresh fa-spin mr-2'></i>  Loading");
            }).ajaxStop(function() {
            });

            var id = $('#team_id').val();
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to disbursed salary!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "<?php echo e(route('disburse.salary')); ?>",
                        type: 'POST',
                        data: {
                            'id': id,
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response){
                            // console.log(response)
                            Swal.fire(
                                response.message,
                                '',
                                'success'
                            );
                            location.reload();
                            $(".disbursed").attr("disabled", "disabled");
                            $(".disbursed").html("disbursed");
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-7.4\htdocs\wamztech-crm\resources\views/user-salary/show.blade.php ENDPATH**/ ?>