<?php $__env->startSection('page-title','Projects'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.project')): ?> no-btn <?php endif; ?>">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>
        <div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.project')): ?>
                <a href="<?php echo e(route('create.project')); ?>" class="btn btn-primary ">Create</a>
            <?php endif; ?>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <div id="accordion">
                        <?php $__currentLoopData = $project_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card">
                                <div class="card-header" id="heading<?php echo e($type->id); ?>">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse<?php echo e($type->id); ?>" aria-expanded="true" aria-controls="collapse<?php echo e($type->id); ?>">
                                            <?php echo e($type->title); ?>

                                        </button>
                                    </h5>
                                </div>

                                <div id="collapse<?php echo e($type->id); ?>" class="collapse" aria-labelledby="heading<?php echo e($type->id); ?>" data-parent="#accordion">
                                    <div class="card-body">
                                        <p>
                                            <a href="<?php echo e(route('team-work', base64_encode($type->id))); ?>" target="_blank" class="btn btn-success ">Team Work
                                                <i class="fa fa-external-link"></i>
                                            </a>
                                        </p>
                                        <table class="table pmd-table table-hover pmd-table-card datatable-project" id="TABLE_<?php echo e($type->id); ?>">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>S No.</th>
                                                <th>Title</th>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                                <th>Account Manager</th>
                                                <th>Project Manager</th>
                                                <th>Client Name</th>
                                                <th>Type</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__currentLoopData = $projects[$key]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($i++); ?></td>
                                                    <td>
                                                        <a href="<?php echo e(route('team-work.tasks', $value->id)); ?>" target="_blank">
                                                            <?php echo e($value->project_name); ?>

                                                        </a>
                                                    </td>
                                                    <td><?php echo e($value->start_date); ?></td>
                                                    <td><?php echo e($value->end_date); ?></td>
                                                    <td><?php echo e($value->findAccountManager->name??"N/A"); ?></td>
                                                    <td><?php echo e($value->findProjectManager->name??"N/A"); ?></td>
                                                    <td><?php echo e($value->findClient->name??"N/A"); ?></td>
                                                    <td><?php echo e($value->findType->title??"N/A"); ?></td>
                                                    <td><?php echo e($value->findProjectStatus->title??"N/A"); ?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit.project')): ?>
                                                            <a class="btn btn-primary" href="<?php echo e(route('edit.project',['id'=>base64_encode($value->id)])); ?>" title='Edit'><i class="fa fa-pencil"></i></a>
                                                            <?php endif; ?>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete.project')): ?>
                                                                <button class='btn btn-danger delete-btn' data-id='<?php echo e(base64_encode($value->id)); ?>' title='Delete'><i class='fa fa-trash'></i> </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        var table;
        $(document).ready( function () {
            $('.select-two').select2();
            // $('.datatable-project').DataTable();
            var project_types_array = <?php echo e($project_types_array); ?>

            /*project_types_array.forEach(function(currentValue, index){
                console.log(currentValue)
                $('#TABLE_'+currentValue).DataTable();
                // setTimeout(function () {}, 2000)
            })*/

                function ajaxRequest (project_types_array) {
                    if (project_types_array.length > 0) {
                        var project_type_id = project_types_array.pop();
                        setTimeout(function () {
                            $('#TABLE_'+project_type_id).DataTable();
                        }, 1000)
                        ajaxRequest(project_types_array);
                    }
                }

            ajaxRequest(project_types_array);
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(URL::to('site/project/delete')); ?>' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\webprojects\xampp-7.4\htdocs\laravel\portalwamztech\app\resources\views/projects/index.blade.php ENDPATH**/ ?>