<?php $__env->startSection('page-title','Loans'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

    <style>
        #exampleModal > .modal-dialog {
            max-width: 880px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->

        <!--breadcrumb start-->
        <div class="float-right no-btn">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>
        <div>
            
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Requested By</th>
                                <th>Requested Amount</th>
                                <th>Accepted Amount</th>
                                <th>Inst. Total</th>
                                <th>Inst. Remaining</th>
                                <th>Inst. Amount</th>
                                <th>Disbursement Date</th>
                                <th>Status</th>
                                <th style="width: 17%">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($loan->findUser->name??''); ?></td>
                                    <td><?php echo e($loan->amount_requested); ?></td>
                                    <td><?php echo e($loan->amount_accepted??'N/A'); ?></td>
                                    <td><?php echo e($loan->number_of_installments_total); ?></td>
                                    <td><?php echo e($loan->number_of_installments_remaining??'N/A'); ?></td>
                                    <td><?php echo e($loan->installment_amount??'N/A'); ?></td>
                                    <td><?php echo e($loan->disbursement_date
                                                ?(\Carbon\Carbon::make($loan->disbursement_date)->format('d-m-Y'))
                                                :'N/A'); ?>

                                    </td>
                                    <td>
                                        <span class="badge badge-warning"><?php echo e($loan->status); ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-primary loan-details" data-id="<?php echo e($loan->id); ?>">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                            <a href="<?php echo e(route('edit.loan', base64_encode($loan->id))); ?>" class="btn btn-success">
                                                <i class="fa fa-pencil"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="modal-body">
                        <div class="row" id="data-row">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

    <script>
        $(document).ready( function () {
            $('#roles-datatable').DataTable();
        });

        $(document).on('click', '.loan-details', function () {
            $('#data-row').html('')
            let id = $(this).data('id')

            $.ajax({
                url: '<?php echo e(URL::to('site/loan/loan-details')); ?>' +"/"+ id,
                type: 'get',
                success: function(response){
                    if(response.status === true){
                        $('#data-row').html(response.html)
                        $('#exampleModalLabel').html(response.title)
                        $('#exampleModal').modal('show')
                    }
                }
            });

        })

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(URL::to('site/loan/delete')); ?>' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/loan/index_admin_pending.blade.php ENDPATH**/ ?>