<?php

namespace App\Http\Controllers;

use App\Models\UserLoginDetails;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AttendanceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function check_in(Request $request){

        $loginDetailsModel = new UserLoginDetails();
        $log_id = $loginDetailsModel->storeLoginDetails($request);
        $request->session()->put('log_id', $log_id);

        return $log_id;
    }

    public function check_out(Request $request){

        if (session()->has('log_id')){

            $loginDetails = new UserLoginDetails();
            $loginDetails->logout_details(session()->get('log_id')->id);

            $log_id = $loginDetails->verify_check_in(session()->get('log_id'));
            $request->session()->put('log_id', $log_id);

            return $log_id;
        }
    }

    public function checkInOut(Request $request){
//        dd('work');
//        dd($request->all());
        if (session()->get('log_id') && session()->get('log_id') !=''){

            date_default_timezone_set('Asia/Karachi');

            $startTime = new Carbon(session()->get('log_id')->login_date_time);
            $endTime = new Carbon();

            $log  = $startTime->diff($endTime)->format('%h:%i');

            $start = new Carbon(auth()->user()->findShift->total_hours);
            $end = new Carbon($log);
            $log2  = $start->diff($end)->format('%h:%i');
//            dd($log2);
            return response()->json(['status'=>'200','workedtimecheck'=>$log,'remainingtimecheck'=>$log2]);

        }
    }
}
