<?php

namespace App\Http\Controllers;

use App\Models\JobTitle;
use Illuminate\Http\Request;

class JobTitleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $job_titles = JobTitle::orderBy('title')->get();
        return view('job-titles.index', compact('job_titles'));
    }

    public function create(){
        return view('job-titles.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        JobTitle::create($request->all());
        return redirect()->route('job-title')->with('mesg', 'Job title created successfully');
    }

    public function edit($id){
        $job_title = JobTitle::find(base64_decode($id));
        if ($job_title){
            return view('job-titles.edit', compact('job_title'));
        }else{
            return redirect()->back()->with('error','Job title not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        $job_title = JobTitle::find($request->id);
        if ($job_title){
            $res = $job_title->update($request->all());
            if ($res){
                return redirect()->route('job-title')->with('mesg','Job title updated successfully.');
            }
        }
    }

    public function delete($id){
        $job_title = JobTitle::find(base64_decode($id));
        if($job_title){
            $job_title->delete();
            return response('Job title deleted successfully');
        }else{
            return response('Job title not found');
        }
    }
}
