<?php

namespace App\Http\Controllers;

use App\Models\Team;
use App\Models\TeamToMember;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class TeamController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('teams.index');
    }

    public function showAllTeams(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2=> 'team_head_user_id',
            3=> 'status',
        );

        $totalDataRecord = Team::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'teams.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Team::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $dataedit =  route('edit.team',['id'=>$id]);
                $status = ($post_val->status == 1)?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>In-Active</span>";

                $delete_team = Gate::allows("delete.team")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_team = Gate::allows("edit.team")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['team_head_user_id'] = $post_val->findUser->name??'N/A';
                $postnestedData['status'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_team}  {$delete_team}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        $users = User::all()->except('1');
        $teamModel = new Team();
        $available_users = $teamModel->availableUsers();

        return view('teams.create',compact('users','available_users'));
    }

    public function store(Request $request){

        $request->validate([
            'title'               => 'required',
            'team_head_user_id'   => 'required',
            'status'              => 'required',
        ]);

        $team = Team::create($request->all());

        if ($request->team_member_user_id || $request->team_head_user_id) {

            $team_member_user_id[] = $request->team_head_user_id;
            $request->merge(['team_member_user_id' => $team_member_user_id]);

            $teamMemberModel = new TeamToMember();
            $teamMemberModel->createTeamMembers($team->id, $request->team_member_user_id);

        }

        return redirect()->route('team')->with('mesg','Team created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $teamModel = new Team();
        $team = $teamModel->find($id);
        if ($team->isEmpty) {
            return redirect()->back()->with('error', 'Team not found.');
        }

        $users = User::all()->except('1');
        $team_users = $team->users;
        $available_users = $teamModel->availableUsers();

        return view('teams.edit',compact('team','users','team_users','available_users'));
    }

    public function update(Request $request){
        $request->validate([
            'title'                 => 'required',
            'team_head_user_id'     => 'required',
            'status'                => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $team = Team::find($request->id);
        if($team){

            if($request->has('team_member_user_id')){
                if(!in_array($request->team_head_user_id,$request->team_member_user_id)){
                    $team_member_user_id = $request->team_member_user_id;
                    $team_member_user_id[] = $request->team_head_user_id;
                    $request->merge(['team_member_user_id' => $team_member_user_id]);
                }
            }else{
                $team_member_user_id[] = $request->team_head_user_id;
                $request->merge(['team_member_user_id' => $team_member_user_id]);
            }

            $teamModel = new TeamToMember();
            $teamModel->deleteTeamMembers($request->id);
            $teamModel->createTeamMembers($request->id,$request->team_member_user_id);

            $team->update($request->all());
        }
        return redirect()->route('team')->with('mesg','Team updated successfully.');
    }

    public function delete($id){
        $id = base64_decode($id);
        $team = Team::find($id);
        $teamModel = new TeamToMember();
        if ($team){
            $team->delete();
            $teamModel->deleteTeamMembers($team->id);
            return response('Team deleted successfully.');
        }else{
            return response('Team not found.');
        }
    }

}
