<?php

namespace App\Http\Controllers;

use App\Models\Allowance;
use App\Models\JobTitle;
use App\Models\Rank;
use App\Models\Role;
use App\Models\Shift;
use App\Models\Team;
use App\Models\TeamToMember;
use App\Models\User;
use App\Models\UserAllowanceInfo;
use App\Models\UserDesignation;
use App\Models\UserLoginDetails;
use App\Models\UserStatus;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


class UserController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('users.index');
    }

    public function showAllEmployees(Request $request){

        $columns_list = array(
            0 =>'id',
            7 =>'name',
            8=> 'client_display_name',
            9=> 'email',
            20=> 'phone',
            3=> 'role_id',
            2=> 'shift_id',
            5=> 'join_date',
            6=> 'leaving_date',
            4=> 'rank_id',
            22=> 'image',
            16=> 'status_id',
        );

        $totalDataRecord = User::where('user_type_id',1)->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = User::where('user_type_id',1)->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

//            $post_data =  User::where('id','LIKE',"%{$search_text}%")
//                ->orWhere('name', 'LIKE',"%{$search_text}%")
//                ->orWhere('client_display_name', 'LIKE',"%{$search_text}%")
//                ->orWhere('email', 'LIKE',"%{$search_text}%")
//                ->orWhere('status_id', 'LIKE',"%{$search_text}%")
//                ->orWhere('phone', 'LIKE',"%{$search_text}%")
//                ->offset($start_val)
//                ->limit($limit_val)
//                ->orderBy($order,$dir_val)
//                ->get();
            $post_data =  User::where(function ($q) use ($search_text) {
                $q->where('id','LIKE',"%{$search_text}%")
                    ->orWhere('name', 'LIKE',"%{$search_text}%")
                    ->orWhere('client_display_name', 'LIKE',"%{$search_text}%")
                    ->orWhere('email', 'LIKE',"%{$search_text}%")
                    ->orWhere('status_id', 'LIKE',"%{$search_text}%")
                    ->orWhere('phone', 'LIKE',"%{$search_text}%");
                })
                ->where('user_type_id',1)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = User::where(function ($q) use ($search_text) {
                $q->where('id','LIKE',"%{$search_text}%")
                    ->orWhere('name', 'LIKE',"%{$search_text}%")
                    ->orWhere('client_display_name', 'LIKE',"%{$search_text}%")
                    ->orWhere('email', 'LIKE',"%{$search_text}%")
                    ->orWhere('status_id', 'LIKE',"%{$search_text}%")
                    ->orWhere('phone', 'LIKE',"%{$search_text}%");
                })
                ->where('user_type_id',1)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $color_class = '';
                switch ($post_val->findStatus->has_access??''){
                    case 1:
                        $color_class = "badge-success";
                        break;
                    case 0:
                        $color_class = "badge-danger";
                        break;
                    default:
                        break;
                }

                $i++;
                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $showdata = route('show.user',['id'=>$id]);
                $dataedit = route('edit.user',['id'=>$id]);
                $status = "<span class='badge ".$color_class."'>".($post_val->findStatus->title??'N/A')."</span>";
                $img = asset('employees/images/'.$post_val->image);
                $show_user = Gate::allows("show.user")?"<a class='btn btn-success btn-style' href='{$showdata}' title='View'><i class='fa fa-eye'></i> </a>":"";
                $delete_user = Gate::allows("delete.user")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_user = Gate::allows("edit.user")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $date = Carbon::now()->format('Y-m');
                $date =  base64_encode($date);
                $Login_history = Gate::allows("show.specific.employee.activity")?"<a class='btn btn-primary btn-style' href='".route('show.specific.employee.activity', ['id'=>$id,'date'=>$date])."' title='Edit'><i class='fa fa-clock'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['name'] = $post_val->name;
                $postnestedData['client_display_name'] = $post_val->client_display_name;
                $postnestedData['email'] = $post_val->email;
                $postnestedData['phone'] = $post_val->phone??'N/A';
                $postnestedData['role_id'] = $post_val->findRole->name??'N/A';
                $postnestedData['shift_id'] = $post_val->findShift->title??'N/A';
                $postnestedData['join_date'] = $post_val->join_date??'N/A';
                $postnestedData['leaving_date'] = $post_val->leaving_date??'Continue';
                $postnestedData['rank_id'] = $post_val->findRank->title??'N/A';
                $postnestedData['image'] = ($post_val->image)?"<img src='".$img."' width='80px' class='rounded mx-auto d-block'>":'N/A';
                $postnestedData['status_id'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$show_user} {$edit_user} {$Login_history} {$delete_user}</div>";

                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        $roles  = Role::where('status',1)->get();
        $shifts = Shift::where('status',1)->get();
        $ranks  = Rank::where('status',1)->get();
        $teams  = Team::where('status',1)->get();
        $allowances = Allowance::where('status',1)->get();
        $status = UserStatus::where('status', 1)->orderBy('title')->get();
        $job_titles = JobTitle::where('status', 1)->orderBy('title')->get();
        $designations = UserDesignation::where('status', 1)->orderBy('title')->get();

        $data = session()->get('data')??[];

        return view('users.create',compact('roles','shifts','ranks','allowances','teams','status','designations','job_titles', 'data'));
    }

    public function store(Request $request){

        $request->validate([
            'firstname'             => 'required|string',
            'lastname'              => 'required|string',
            'client_display_name'   => 'required|string',
            'email'                 => 'required|email|unique:users',
            'password'              => 'required|min:4',
            'basic_salary'          => 'required',
            'total_salary'          => 'required',
            'gender'                => 'required',
            'marital_status'        => 'required',
            'role_id'               => 'required|string',
            'shift_id'              => 'required|string',
            'team_id'               => 'required|array',
            'status_id'             => 'required',
            'designation_id'        => 'required',
            'job_title_id'          => 'required',
            'join_date'             => 'required',
            'bank'                  => 'required',
            'account_title'         => 'required',
            'account_number'        => 'required',
        ]);

        $request->merge(['password' => Hash::make($request->password)]);
        $request->merge(['name' => $request->firstname.' '.$request->lastname]);

        if ($request->hasFile('file')){

            $fileName = $request->file->getClientOriginalName();
            $request->file->move(public_path('employees/images'), $fileName);
            $request->merge(['image' => $fileName]);

        }
        $user = User::create($request->all());

        //Update team head
        if ($request->has('is_head')){
            $teams = Team::whereIn('id',$request->team_id)->get();
            foreach ($teams as $team){
                $team->update([
                    'team_head_user_id' => $user->id,
                ]);
            }
        }

        //Add User to the team
        foreach ($request->team_id as $id){
            TeamToMember::create([
                'team_id' => $id,
                'user_id' => $user->id,
            ]);
        }

        //Add User allowance info
        $user_allowance_model = new UserAllowanceInfo();
        $res = $user_allowance_model->storeUserAllowances($user->id,$this->getUserAllowances($request));
        if ($res){
            return redirect()->route('user')->with('mesg','Employee created successfully.');
        }
    }

    public function show($id){

        $id = base64_decode($id);
        $user = User::find($id);
        $date1 = date_create($user->join_date);
        $date2 = date_create($user->end_date??date('d-m-Y'));
        $workedTime = date_diff($date1, $date2)->format('%y years , %m months and %d days');

        $user_teams = [];

        if($user){
            foreach ($user->findTeams as $team) {
                $user_teams[]= $team->findTeam->title??'';
            }

            $allowances = Allowance::where('status',1)->get();
            $userAllowanceId = [];
            foreach ($user->findAllowances as $userAllowances) {
                $userAllowanceId[$userAllowances->allowance_id] = $userAllowances->amount;
            }
            return view('users.show',compact('user','allowances','userAllowanceId','user_teams','workedTime'));
        }
    }

    public function edit($id){
        $id = base64_decode($id);
        $user = User::find($id);
        $user_teams = [];
        $status = UserStatus::where('status', 1)->orderBy('title')->get();
        $job_titles = JobTitle::where('status', 1)->orderBy('title')->get();
        $designations = UserDesignation::where('status', 1)->orderBy('title')->get();

        if($user){
            $roles  = Role::where('status',1)->get();
            $shifts = Shift::where('status',1)->get();
            $ranks  = Rank::where('status',1)->get();
            $teams  = Team::where('status',1)->get();
            $allowances = Allowance::where('status',1)->get();

            foreach ($user->findTeams as $team) {
                $user_teams[$team->findTeam->id??''] = $team->findTeam->title ??'';
            }

            $userAllowanceId = [];
            foreach ($user->findAllowances as $userAllowances) {
                $userAllowanceId[$userAllowances->allowance_id] = $userAllowances->amount;
            }

            return view('users.edit',compact('userAllowanceId', 'user','roles','shifts','ranks','allowances','teams','user_teams','status','job_titles','designations'));
        }else{
            return redirect()->back()->with('error','Employee not found.');
        }
    }

    public function update(Request $request){

        $request->validate([
            'firstname'             => 'required|string',
            'lastname'              => 'required|string',
            'client_display_name'   => 'required|string',
            'email'                 => 'required|email',
            'basic_salary'          => 'required',
            'total_salary'          => 'required',
            'gender'                => 'required',
            'marital_status'        => 'required',
            'role_id'               => 'required|string',
            'shift_id'              => 'required|string',
            'team_id'               => 'required|array',
            'status_id'             => 'required',
            'designation_id'        => 'required',
            'job_title_id'          => 'required',
            'join_date'             => 'required',
            'bank'                  => 'required',
            'account_title'         => 'required',
            'account_number'        => 'required',
        ]);

        $request->merge(['id' => base64_decode($request->id)]);

        $user = User::find($request->id);
        $status = UserStatus::find($request->status_id);
        if($user){

            if (!$status->has_access){

               $by_user = auth()->user()->name;
               $date   = ($request->leaving_date)?$request->leaving_date:now()->format('d-m-Y');
               $reason = ($request->reason)?$request->reason:"status updated to $status->title by $by_user";

                $request->merge([
                    'leaving_date' => $date,
                    'reason' => $reason,
                ]);
            }

            $request->merge([
                'name' => $request->firstname.' '.$request->lastname,
                'updated_at' => Carbon::now(),
            ]);

            if ($request->hasFile('file')){
                $fileName = $request->file->getClientOriginalName();
                $request->file->move(public_path('employees/images'), $fileName);
                $request->merge(['image' => $fileName]);
            }

            $user->update($request->all());

            //Update team head
            if ($request->has('is_head')){
                $teams = Team::whereIn('id',$request->team_id)->get();
                foreach ($teams as $team){
                    $team->update([
                        'team_head_user_id' => $user->id,
                    ]);
                }
            }

            //Delete associated teams of user
            TeamToMember::where('user_id',$user->id)->delete();

            //Add User to the team
            foreach ($request->team_id as $id){
                TeamToMember::create([
                    'team_id' => $id,
                    'user_id' => $user->id,
                ]);
            }

            $user_allowance_model = new UserAllowanceInfo();
            $user_allowance_model->deleteUserAllowances($user->id);
            $res = $user_allowance_model->storeUserAllowances($user->id,$this->getUserAllowances($request));
            if ($res){
                return redirect()->route('user')->with('mesg','Employee updated successfully.');
            }
        }
    }

    public function delete($id){
        $id = base64_decode($id);
        $user = User::find($id);
        if($user){
            $user_allowance_model = new UserAllowanceInfo();
            $user_allowance_model->deleteUserAllowances($user->id);
            $user->delete();
            return response('Employee deleted successfully.');
        }else{
            return response('Employee not found.');
        }
    }

    protected function getUserAllowances(Request $request)
    {
        $allowance_ids = $request->allowance_ids;
        $allowances = [];

        foreach ($allowance_ids as $allowance_id) {
            $allowance = 'allowance_' . $allowance_id . '_amount';
            $allowances[$allowance_id] = $request->$allowance;
        }
        return $allowances;
    }

    public function activity(){
        return view('users.activities');
    }

    public function showAllEmployeeTeam(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2=> 'team_head_user_id',
        );

        $totalDataRecord = Team::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'teams.'.$columns_list[$request->input('order.0.column')];

        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Team::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');

            $post_data =  Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Team::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;
                $deletedata = $post_val->id;
                $id =base64_encode($deletedata);
                $dataShow =  route('show.team.members',['id'=>$id]);

                $show_user = Gate::allows("show.team.members")?"<a class='btn btn-success btn-style' href='{$dataShow}' title='View Team Member'><i class='fa fa-eye'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['team_head_user_id'] = $post_val->findUser->name??'N/A';
                $postnestedData['options'] = " <div class='btn-group'> {$show_user} </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function showTeamMember($id){
        $id = base64_decode($id);
        $team_member = Team::find($id);

        return view('users.showSpecificTeamUser',compact('team_member'));
    }

    public function showSpecificEmployeeTeamMember(Request $request){

        $columns_list = array(
            0 => 'id',
            7 => 'name',
            8 => 'client_display_name',
            22 => 'image',
            9 => 'overtime',
        );
        $team_users = User::leftJoin('team_to_members','users.id','=','team_to_members.user_id')
            ->RightJoin('shifts','users.shift_id','=','shifts.id')
            ->where('team_to_members.team_id','=',$request->id)
            ->get();

        $totalDataRecord = $team_users->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users.' . $columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data =  User::leftJoin('team_to_members','users.id','=','team_to_members.user_id')
                ->RightJoin('shifts','users.shift_id','=','shifts.id')
                ->where('team_to_members.team_id','=',$request->id)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

        }
        else {

            $search_text = $request->input('search.value');

            $post_data = User::leftJoin('team_to_members','users.id','=','team_to_members.user_id')
                ->RightJoin('shifts','users.shift_id','=','shifts.id')
                ->orWhere('users.name', 'LIKE', "%{$search_text}%")
                ->orWhere('users.client_display_name', 'LIKE', "%{$search_text}%")
                ->where('team_to_members.team_id','=',$request->id)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order, $dir_val)
                ->get();

            $totalFilteredRecord = User::where('id', 'LIKE', "%{$search_text}%")
                ->orWhere('name', 'LIKE', "%{$search_text}%")
                ->orWhere('client_display_name', 'LIKE', "%{$search_text}%")
                ->count();
        }

        $data_val = array();

        if (!empty($post_data)) {

            $i = 0;

            $user_login_detail_model = new UserLoginDetails();
            $current_year_month = Carbon::now()->format('Y-m');

            if (isset($request['month']) && $request['month']!=null){
                $current_year_month = $request['month'];
            }

            foreach ($post_data as $post_val) {

                $i++;
                //Calculation Days Month
                $total_month_working_days = $user_login_detail_model->getMonthWorkingDays($current_year_month);
                $total_month_avaliable_days = $user_login_detail_model->getEmployeeWorkingDays($post_val->user_id, $current_year_month);
                $working_hour_monthly_total = $user_login_detail_model->getEmployeeWorkingHour($post_val->user_id, $current_year_month);
                $working_hour_avaliable_in_second = $user_login_detail_model->secondsToTime($working_hour_monthly_total);
                $working_time =  explode(':', $working_hour_avaliable_in_second);
                $shift_total_hour = $post_val->total_hours;
                $shift_total_hour = SUBSTR($shift_total_hour, 0, 2);
                $working_hour_total = ($shift_total_hour * $total_month_working_days);

                //Calculation OverTime
                $overtime_in_second = $user_login_detail_model->overtime($post_val->user_id, $current_year_month);
                $overtime = $user_login_detail_model->secondsToTime($overtime_in_second);
                $overtime =  explode(':', $overtime);

                if ($working_hour_avaliable_in_second > $working_hour_total){
                    $working_hour_totals =  $working_hour_total * 3600;
                    $working_hour_avaliables =  $user_login_detail_model->timeToSeconds( $working_hour_avaliable_in_second);
                    $time = $working_hour_avaliables - $working_hour_totals;
                    $time = $time + $overtime_in_second;
                    $overtime = $user_login_detail_model->secondsToTime($time);
                    $overtime =  explode(':', $overtime);
                }

                $deletedata = $post_val->user_id;
                $id = base64_encode($deletedata);

                //$date = (!empty($request['month']))?$request['month']:Carbon::now()->format('Y-m');

                if (!empty($request['month'])){
                    $date = $request['month'];
                }else{
                    $date = Carbon::now()->format('Y-m');
                }
                $date =  base64_encode($date);
                $showdata = route('show.specific.employee.activity', ['id'=>$id,'date'=>$date]);

                $show_user = Gate::allows("show.specific.employee.activity")?"<a class='btn btn-success btn-style' href='{$showdata}' title='View Specific Employee Activity'><i class='fa fa-eye'></i> </a>":"";

                $img = asset('employees/images/' . $post_val->image);

                //Overtime Calculation
                $postnestedData['id'] = $i;
                $postnestedData['name'] = $post_val->name ?? 'N/A';
                $postnestedData['client_display_name'] = $post_val->client_display_name ?? 'N/A';
                $postnestedData['image'] = ($post_val->image) ? "<img src='" . $img . "' width='80px' class='rounded mx-auto d-block'>" : 'N/A';
                $postnestedData['working_hour_total'] = $working_hour_total . ' hours' ?? 'N/A';
                $postnestedData['working_hour_avaliable'] = $working_time[0] . ' hours' . ' ' . $working_time[1] . ' minutes' ?? 'N/A';
                $postnestedData['total_month_working_days'] = $total_month_working_days . ' days' ?? 'N/A';
                $postnestedData['available_working_days'] = $total_month_avaliable_days . ' days' ?? 'N/A';
                $postnestedData['over_time'] =  $overtime[0] . ' hours' . ' ' . $overtime[1] . ' minutes' ?? 'N/A';
                $postnestedData['options'] = " <div class='btn-group'> {$show_user} </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw" => intval($draw_val),
            "recordsTotal" => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data" => $data_val
        );

        echo json_encode($get_json_data);
    }

    public function showSpecificEmployee($id,$date){
//        dd('work');
        $id = base64_decode($id);
        $date = base64_decode($date);

       $user = User::find($id);

        if($user){
            return view('users.showSpecificUser',compact('user','date'));
        }
    }

    public function showAllEmployeeActivity(Request $request){
        $current_year_month = $request['date'];

        if (isset($request['month'] ) && $request['month'] !=null){
            $current_year_month = $request['month'];
        }
        $columns_list = array(
            0 =>'id',
            5 =>'user_attendance_date',
            8=> 'working_hours',
            9=>'overtime'
        );

        $totalDataRecord =  UserLoginDetails::where('user_id',$request['id'])
            ->Where('login_date_time', 'LIKE',"%{$current_year_month}%")
            ->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users_login_details.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {

            $post_data =  UserLoginDetails::where('user_id',$request['id'])
                ->Where('login_date_time', 'LIKE',"%{$current_year_month}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get()
                ->unique('user_attendance_date');
        }
        else {
            $search_text = $request->input('search.value');

            $post_data =  UserLoginDetails::where('user_id',$request['id'])
                ->orWhere('user_attendance_date', 'LIKE',"%{$search_text}%")
                ->Where('login_date_time', 'LIKE',"%{$current_year_month}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get()
                ->unique('user_attendance_date');

            $totalFilteredRecord = UserLoginDetails::where('id','LIKE',"%{$search_text}%")
                ->orWhere('user_attendance_date', 'LIKE',"%{$search_text}%")
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            $user_login_detail_model = new UserLoginDetails();
            $work_days_ = ($request['month'])?$request['month']:now()->format('Y-m');
            $daily  =  $user_login_detail_model->getTotalMonthWorkingDays($work_days_);
            foreach ($daily as $post_vall)
            {
//                $daily  =  $user_login_detail_model->getTotalMonthWorkingDays(now()->format('Y-m'));
                $data_month_year = ($request['month'] && $request['month'] != now()->format('Y-m'))?$request['month']:$post_vall <= now()->format('d-m-Y');


                if($data_month_year){

                    $query_date = Carbon::parse($post_vall)->format('Y-m-d');
                    $post_val =  UserLoginDetails::where('user_id',$request['id'])
                        ->Where('user_attendance_date',"{$query_date}")
                        ->first();

                    if ($post_val){
                        $i++;

                        $working_hour_avaliable     =  $user_login_detail_model->getEmployeeWorkingHour($post_val->user_id,$post_val->user_attendance_date);
                        $working_hour_avaliable_in_second     = $user_login_detail_model->secondsToTime($working_hour_avaliable);
                        $working_time =  explode(':', $working_hour_avaliable_in_second);

                        //OverTime

                        $overtime  = $user_login_detail_model->overtimeDate($post_val->user_id,$post_val->user_attendance_date);
                        $overtime     = $user_login_detail_model->secondsToTime($overtime);
                        $overtime =  explode(':', $overtime);

                        //Count Login Time
                        $count = $user_login_detail_model->loginCount($post_val->user_id,$post_val->user_attendance_date);

                        $deletedata = $post_val->user_id;
                        $id =  base64_encode($deletedata);
                        $date =  base64_encode($post_val->user_attendance_date);
                        $showdata =  route('user.date.login.activity',['id'=>$id,'date'=>$date]);

                        $check_in_date_time = ($post_val->login_date_time)?Carbon::parse($post_val->login_date_time)->format('H:i:s'):$post_val->login_date_time;
                        $check_out_date_time = ($post_val->logout_date_time)?Carbon::parse($post_val->logout_date_time)->format('H:i:s'):$post_val->logout_date_time;

                        $show_user = Gate::allows("user.date.login.activity")?"<a class='btn btn-success btn-style' href='{$showdata}' title='View'><i class='fa fa-eye'></i> </a>":"";
                        $check_in_and_out ="<a class='btn btn-primary btn-style ml-1 check_in_and_out' href='{$showdata}' data-check_in_date_time='{$check_in_date_time}' data-check_out_date_time='{$check_out_date_time}' data-user_attendance_date='{$post_val->user_attendance_date}'  data-toggle='modal' data-target='#exampleModalCenter' title='Update Check in-out'><i class='fa fa-clock-o'></i> </a>";

                        $postnestedData['id'] = $i;

                        $postnestedData['user_attendance_date'] = ($post_val->user_attendance_date)?Carbon::parse($post_val->user_attendance_date)->format('d-m-Y'):'N/A';
                        $postnestedData['working_hours'] =  $working_time[0] . ' hours' . ' ' . $working_time[1] . ' minutes' ?? 'N/A';
                        $postnestedData['over_time'] =  $overtime[0] . ' hours' . ' ' . $overtime[1] . ' minutes' ?? 'N/A';
                        $postnestedData['count'] = $count.' times' ?? 'N/A';
                        $postnestedData['options'] = " <div class='btn-group'> {$check_in_and_out} </div>";
                        $data_val[] = $postnestedData;

                    }else{

                        $id =  $request['id'];
                        $date =  Carbon::parse($post_vall)->format('Y-m-d');
                        $showdata =  route('user.date.login.activity',['id'=>$id,'date'=>$date]);
                        $check_in_and_out ="<a class='btn btn-primary btn-style ml-1 check_in_and_out' href='{$showdata}' data-user_attendance_date='{$date}' data-toggle='modal' data-target='#exampleModalCenter' title='Update Check in-out'><i class='fa fa-clock-o'></i> </a>";

                        $i++;
                        $postnestedData['id'] = $i;
                        $postnestedData['user_attendance_date'] = $post_vall;
                        $postnestedData['working_hours'] = 'N/A';
                        $postnestedData['over_time'] = 'N/A';
                        $postnestedData['count'] = 'N/A';
                        $postnestedData['options'] = " <div class='btn-group'> {$check_in_and_out} </div>";
                        $data_val[] = $postnestedData;

                    }
                }

//                }
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function showSpecificEmployeeDateActivity($id,$date){

        $id = base64_decode($id);
        $date = base64_decode($date);
        $user = User::find($id);

        if($user){
            return view('users.showDateWiseLoginActivity',compact('user','date'));
        }
    }

    public function showAllSpecificEmployeeDateActivity(Request $request){

        $columns_list = array(
            0 =>'id',
            2 =>'login_date_time',
            3 =>'logout_date_time',
            8=> 'working_hours',
        );

        $totalDataRecord =  UserLoginDetails::where('user_id',$request['id'])
            ->Where('login_date_time', 'LIKE',"%{$request['date']}%")
            ->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users_login_details.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {

            $post_data =  UserLoginDetails::where('user_id',$request['id'])
                ->Where('login_date_time', 'LIKE',"%{$request['date']}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {

            $search_text = $request->input('search.value');
            $post_data =   UserLoginDetails::orWhere('user_attendance_date', 'LIKE',"%{$search_text}%")
                ->Where('login_date_time', 'LIKE',"%{$request['date']}%")
                ->Where('user_id',$request['id'])
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = UserLoginDetails::orWhere('user_attendance_date', 'LIKE',"%{$search_text}%")
                ->Where('login_date_time', 'LIKE',"%{$request['date']}%")
                ->Where('user_id',$request['id'])
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;

            $user_login_detail_model = new UserLoginDetails();
            foreach ($post_data as $post_val) {

                $i++;

                $working_hour_avaliable_in_second = $user_login_detail_model->secondsToTime($post_val->working_hours);
                $working_time =  explode(':', $working_hour_avaliable_in_second);

                $postnestedData['id'] = $i;
                $postnestedData['login_date_time'] = $post_val->login_date_time??'N/A';
                $postnestedData['logout_date_time'] = $post_val->logout_date_time??'N/A';
                $postnestedData['working_hours'] =  $working_time[0] . ' hours' . ' ' . $working_time[1] . ' minutes' ?? 'N/A';

                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function userCheckInTime(Request $request){

        $checkAttendance = UserLoginDetails::where("user_id",$request->user_id)
                    ->where('user_attendance_date',$request->user_attendance)
                    ->first();

        if ($checkAttendance){

            date_default_timezone_set('Asia/Karachi');

            $check_in_date = $request->user_attendance." ".$request->user_check_in;
            $check_out_date = $request->user_attendance." ".$request->user_check_out;

            if (isset($request->user_check_out)){
                $t = date('h:i:s a', strtotime($request->user_check_out));
//                dd($t);
                $check_time = substr($t,9,2);
                if($check_time == "am") {
                    $attendance = date('Y-m-d', strtotime($request->user_attendance. ' +1 day'));
                    $check_out_date = $attendance." ".$request->user_check_out;
                }
            }

            $check_in_time = UserLoginDetails::where("user_id",$request->user_id)->where('user_attendance_date',$request->user_attendance)->first();

            if ($request->user_check_in && $request->user_check_out){
                $check_in_time->update(['login_date_time' => $check_in_date, 'logout_date_time' => $check_out_date]);
            }elseif ($request->user_check_in){
                $check_in_time->update(['login_date_time' => $check_in_date]);
                return response()->json(["status"=>'success',"mesg"=>'Check In-Out Time Updated successfully.']);
            }

            $log_id =  $check_in_time->id;
            $user_id = $check_in_time->user_id;
            $data = [
                'log_id'=>$log_id,
                'user_id'=>$user_id,
            ];

            $loginDetailsModel = new UserLoginDetails();
            $loginDetailsModel->check_in_time_update($data);

            return response()->json(["status"=>'200',"mesg"=>'Check In-Out Time Updated successfully.']);

        }else{

           $request->validate([
                'user_check_in' => 'required',
                'user_check_out' => 'required',
            ]);

            $check_in_date = $request->user_attendance." ".$request->user_check_in;
            $check_out_date = $request->user_attendance." ".$request->user_check_out;

            if (isset($request->user_check_out)){
                $t = date('h:i:s a', strtotime($request->user_check_out));

                $check_time = substr($t,9,2);
                if($check_time == "am") {
                    $attendance = date('Y-m-d', strtotime($request->user_attendance. ' +1 day'));
                    $check_out_date = $attendance." ".$request->user_check_out;
                }
            }


            $data = [
                'user_attendance'=>$request->user_attendance,
                'user_id'=>$request->user_id,
                'check_in_date'=>$check_in_date,
                'check_out_date'=>$check_out_date,
            ];

            $loginDetailsModel = new UserLoginDetails();
            $loginDetailsModel->check_in_time_update($data);

            return response()->json(["status"=>'200',"mesg"=>'Check In-Out Time Updated successfully.']);

        }
    }
}
