<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserStatus;
use Illuminate\Http\Request;

class UserStatusController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $user_status = UserStatus::orderBy('title')->get();
        return view('user-status.index', compact('user_status'));
    }

    public function create(){
        return view('user-status.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'has_access'    => 'required',
            'status'        => 'required',
        ]);

        UserStatus::create($request->all());
        return redirect()->route('user-status')->with('mesg', 'User Status created successfully');
    }

    public function edit($id){
        $user_status = UserStatus::find(base64_decode($id));
        if ($user_status){
            return view('user-status.edit', compact('user_status'));
        }else{
            return redirect()->back()->with('error','User status not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'has_access'    => 'required',
            'status'        => 'required',
        ]);

        $user_status = UserStatus::find($request->id);
        if ($user_status){
            $res = $user_status->update($request->all());
            if ($res){
                return redirect()->route('user-status')->with('mesg','User status updated successfully.');
            }
        }
    }

    public function delete($id){
        $user_status = UserStatus::find(base64_decode($id));
        if($user_status){
            $user_status->delete();
            return response('User status deleted successfully');
        }else{
            return response('User status not found');
        }
    }
}
