<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectStatus extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'projects_status';
    protected $guarded = ['_token'];

    public function findProjects(){
        return $this->hasMany(Project::class, 'status_id');
    }

    public function findType(){
        return $this->belongsTo(ProjectType::class, 'project_type_id');
    }
}
