<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Salary extends Model
{
    use HasFactory;

    public function findAllowance(){
        return $this->belongsTo(Allowance::class, 'allowance_id');
    }

    // Tax Deduction On Salary
    public function taxDeduction($payable_amount_monthly_salary){
        $payable_amount_monthly_original = $payable_amount_monthly_salary;
        $payable_amount_monthly = $payable_amount_monthly_original;
        $payable_amount_yearly = $payable_amount_monthly * 12;

        $taxslab = TaxSlab::whereRaw('"'.$payable_amount_yearly.'" between `min_amount` and `max_amount`')
            ->where("status",1)
            ->first();

        $fixed_deduction = 0;
        $min_amount = 0;
        $tax_percentage = 1;
        if ($taxslab)
        {
            $fixed_deduction = $taxslab->fixed_deduction;
            if ($taxslab->min_amount > 0){
                $min_amount = $taxslab->min_amount - 1;
            }
            $tax_percentage = $taxslab->tax_percentage;
        }
        $taxable_amount_yearly = $payable_amount_yearly - $min_amount;
        $calculated_tax_amount_yearly = ($taxable_amount_yearly / 100) * $tax_percentage;

        // Full year tax deduction
        $total_tax_deduction_yearly = $calculated_tax_amount_yearly + $fixed_deduction;
        $total_tax_deduction_monthly = $total_tax_deduction_yearly / 12;

        $payable_amount_monthly = $payable_amount_monthly - $total_tax_deduction_monthly;

        $data['monthly_income'] = $payable_amount_monthly_original;
        $data['monthly_tax'] = $total_tax_deduction_monthly;
        $data['salary_after_tax'] = $payable_amount_monthly;
        $data['yearly_income'] = $payable_amount_yearly;
        $data['yearly_tax'] = $total_tax_deduction_yearly;
        $data['yearly_income_after_tax'] = $payable_amount_yearly - $total_tax_deduction_yearly;
        return $data['salary_after_tax'];
    }

    // paid and unpaid leaves
    public function leaves($arg){
        $user = $arg;
        $Leave = [];
        $time_date = now()->format('Y');
        $leave = LeaveRequests::where('leave_from_date', 'LIKE', "%{$time_date}%")
            ->where("user_id",$user)
            ->where('status','Approved')
            ->get()
            ->unique('leave_type_id');

        foreach ($leave as $value){

            if ($this->sumLeaves($user,$value->leave_type_id) > $value->findLeaveType->no_of_leaves){

                $paidLeave = $this->pleave($user,$value->leave_type_id);
                $Leave['paid'][$value->findLeaveType->title] = $paidLeave;
            }else{
                $unpaidLeave = $this->pleave($user,$value->leave_type_id);
                $Leave['unpaid'][$value->findLeaveType->title] = $unpaidLeave;
            }
        }
        return $Leave;
    }

    private function sumLeaves($user,$leave_type_id){
        $date = now()->format('Y');
        $sumleave = LeaveRequests::where("user_id",$user)
            ->where("leave_type_id",$leave_type_id)
            ->where('status','Approved')
            ->where('leave_from_date', 'LIKE', "%{$date}%")
            ->sum('number_of_days');

        return $sumleave;
    }

    private function pleave($user,$leave_type_id){
        $date = now()->subMonth()->format('m');
        $sumleave = LeaveRequests::where("user_id",$user)
            ->where("leave_type_id",$leave_type_id)
            ->where('status','Approved')
            ->where('leave_from_date', 'LIKE', "%{$date}%")
            ->sum('number_of_days');
        return $sumleave;
    }

    // User mark as late IN
    public function userMarkAsLate($user_id,$month_year){

        $user = UserLoginDetails::where("user_id",$user_id)
            ->where("login_date_time",'LIKE',"%{$month_year}%")
            ->where("marked_as_late",'1')
            ->get()->unique('user_attendance_date');

        return (int) ($user->count()/3);
    }

    // User mark as late OUT
    public function userMarkedAsEarlyOut($user_id,$month_year){

        $user = UserLoginDetails::where("user_id",$user_id)
            ->where("logout_date_time",'LIKE',"%{$month_year}%")
            ->where("marked_as_early_out",'1')
            ->get()->unique('user_attendance_date');

        return (int) ($user->count()/3);
    }

    // user allowances
    public function userAllownce($user_id){
        $user = User::find($user_id);
        $userAllowanceId = [];
        foreach ($user->findActiveAllowances as $userAllowances) {
            $userAllowanceId[$userAllowances->allowance_id] = $userAllowances->amount;
        }
        return $userAllowanceId;
    }

    // change seconds into hours
    public function secondsToHours($seconds_time)
    {
        if ($seconds_time) {
            $hours = floor($seconds_time / 3600);
            $minutes = floor(($seconds_time - $hours * 3600) / 60);
            $d_hours = ($minutes/60);
            $hours = ($hours + $d_hours);
            $seconds = floor($seconds_time - ($hours * 3600) - ($minutes * 60));
            return $hours;
        }
    }

    public function otherCalculation($user_id){
        $date = now()->format('Y-m');
        $otherCal = GeneratedSalary::where('user_id',$user_id)->where('created_at','LIKE',"%{$date}%")->first();
        return $otherCal;
    }

}
