<?php

namespace App\Http\Controllers;


use App\Models\Notification;
use \App\Models\User;
use App\Models\Project;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $users = User::where('user_type_id',1)->get();
        $projects = Project::all();

        return view('dashboard',compact('users','projects'));
    }
}
