<?php

namespace App\Http\Controllers;

use App\Models\ProjectStatus;
use App\Models\ProjectType;
use Illuminate\Http\Request;

class ProjectStatusController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $project_types = ProjectType::orderBy('title')->pluck('id', 'title')->toArray();
        $data = [];
        foreach ($project_types as $key => $project_type){
            $data[$key][] = $project_type;
            $data[$key][] = ProjectStatus::where('project_type_id', $project_type)->orderBy('project_type_id')->orderBy('sort_order')->get();
        }

        return view('project-status.index', compact('data'));
    }

    public function create(){
        $project_types = ProjectType::orderBy('title')->get();
        return view('project-status.create', compact('project_types'));
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
            'project_type_id' => 'required',
        ]);

        ProjectStatus::create($request->all());
        return redirect()->route('project-status')->with('mesg', 'Project status created successfully');
    }

    public function edit($id){
        $project_status = ProjectStatus::find(base64_decode($id));
        if ($project_status){
            $project_types = ProjectType::orderBy('title')->get();
            return view('project-status.edit', compact('project_status', 'project_types'));
        }else{
            return redirect()->back()->with('error','Project status not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
            'project_type_id' => 'required',
        ]);

        $project_status = ProjectStatus::find($request->id);
        if ($project_status){
            $res = $project_status->update($request->all());
            if ($res){
                return redirect()->route('project-status')->with('mesg','Project status updated successfully.');
            }
        }
    }

    public function delete($id){
        $project_status = ProjectStatus::find(base64_decode($id));
        if($project_status){
            $project_status->delete();
            return response('Project status deleted successfully');
        }else{
            return response('Project status not found');
        }
    }

    public function getProjectStatus($id){
        $project_status = ProjectStatus::where('project_type_id', $id)->get();
        $html = '<option value="" selected hidden></option>';
        foreach ($project_status as $status){
            $html .= '<option value="'.$status->id.'">'.$status->title.'</option>';
        }

        return $html;
    }

    public function sortPosition(Request $request){
        $up =  ProjectStatus::find($request->id);
        $isPositionExist = ProjectStatus::where('project_type_id', $request->project_type_id)->where('sort_order',$request->position)->first();

        if($up && $isPositionExist)
        {
            $up_position = $up->sort_order;
            $up->sort_order = $isPositionExist->sort_order;
            $up->update();

            $isPositionExist->sort_order = $up_position;
            $isPositionExist->update();
            return back()->with('mesg', 'Updated Successfully!');
        }
        elseif($up && !$isPositionExist){
            $up->sort_order = $request->position;
            $up->update();
            return back()->with('mesg', 'Updated Successfully!');
        }
        else{
            return back()->with('error', 'Oops! something went wrong.');
        }
    }
}
