@extends('layouts.app')
@section('page-title','Allowances')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->

        <!--breadcrumb start-->
        <div class="float-right @cannot('create.allowance') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.allowance')
                <a href="{{route('create.allowance')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>title</th>
                                <th>Description</th>
                                <th>Percentage</th>
                                <th>status</th>
                                <th style="width: 17%">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            {{-- @php $i = 1; @endphp
                             @forelse($allowances as $allowance)
                                 <tr>
                                     <td>{{ $i++ }}</td>
                                     <td>{{$allowance->title}}</td>
                                     <td>{{$allowance->description}}</td>
                                     <td>{{$allowance->percentage." %"}}</td>
                                     <td>
                                         @if($allowance->status == 1)
                                             <span class="badge badge-success">Active</span>
                                         @else
                                             <span class="badge badge-danger">In-Active</span>
                                         @endif
                                     </td>
                                     <td>
                                         @can('edit.allowance')
                                             <a class="btn btn-primary btn-style" href="{{route('edit.allowance',base64_encode($allowance->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                         @endcan
                                         @can('delete.allowance')
                                             <button class="btn btn-danger delete-btn" data-id="{{base64_encode($allowance->id)}}" title="Delete"><i class="fa fa-trash"></i> </button>
                                         @endcan
                                     </td>
                                 </tr>
                             @empty
                                 <tr>
                                     <td colspan="6" align="center">No Allowance Available</td>
                                 </tr>
                             @endforelse--}}
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')

    <!-- DataTablesgfk -->
  {{--  <script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>--}}

    <script>
        $(document).ready( function () {
           /* $('#example1').DataTable({
                "responsive": true,
                "autoWidth": false,
                "columnDefs": [
                    { orderable: false, targets: 0 }
                ]
            });*/

            $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "{{ route('show.allowance') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "{{csrf_token()}}"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "title",sortable:false},
                    {"data": "description",sortable:false},
                    {"data": "percentage",sortable:false},
                    {"data": "status",sortable:false},
                    {"data": "options",sortable:false}
                ]
            });
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');
            // alert(id);
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/allowance/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
