@extends('layouts.app')
@section('page-title','Loans')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

    <style>
        #exampleModal > .modal-dialog {
            max-width: 880px;
        }
    </style>
@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->

        <!--breadcrumb start-->
        <div class="float-right no-btn">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            {{--@can('create.loan')
                <a href="{{route('create.loan')}}" class="btn btn-primary">Request Loan</a>
            @endcan--}}
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Requested By</th>
                                <th>Requested Amount</th>
                                <th>Accepted Amount</th>
                                <th>Inst. Total</th>
                                <th>Inst. Remaining</th>
                                <th>Inst. Amount</th>
                                <th>Disbursement Date</th>
                                <th>Status</th>
                                <th style="width: 17%">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 1; @endphp
                            @foreach($loans as $loan)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$loan->findUser->name??''}}</td>
                                    <td>{{$loan->amount_requested}}</td>
                                    <td>{{$loan->amount_accepted??'N/A'}}</td>
                                    <td>{{$loan->number_of_installments_total}}</td>
                                    <td>{{$loan->number_of_installments_remaining??'N/A'}}</td>
                                    <td>{{$loan->installment_amount??'N/A'}}</td>
                                    <td>{{$loan->disbursement_date
                                                ?(\Carbon\Carbon::make($loan->disbursement_date)->format('d-m-Y'))
                                                :'N/A'}}
                                    </td>
                                    <td>
                                        @if($loan->status == 'Accepted')
                                            <span class="badge badge-success">{{$loan->status}}</span>
                                        @elseif($loan->status == 'Disbursed')
                                            <span class="badge badge-primary">{{$loan->status}}</span>
                                        @elseif($loan->status == 'In-Process')
                                            <span class="badge badge-warning">{{$loan->status}}</span>
                                        @elseif($loan->status == 'Returned')
                                            <span class="badge badge-success">{{$loan->status}}</span>
                                        @elseif($loan->status == 'Rejected')
                                            <span class="badge badge-danger">{{$loan->status}}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-primary loan-details" data-id="{{$loan->id}}">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                            {{--<a href="{{route('edit.loan', base64_encode($loan->id))}}" class="btn btn-success">
                                                <i class="fa fa-pencil"></i>
                                            </a>--}}
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="modal-body">
                        <div class="row" id="data-row">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')

    <script>
        $(document).ready( function () {
            $('#roles-datatable').DataTable();
        });

        $(document).on('click', '.loan-details', function () {
            $('#data-row').html('')
            let id = $(this).data('id')

            $.ajax({
                url: '{{URL::to('site/loan/loan-details')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    if(response.status === true){
                        $('#data-row').html(response.html)
                        $('#exampleModalLabel').html(response.title)
                        $('#exampleModal').modal('show')
                    }
                }
            });

        })

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/loan/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
