@extends('layouts.app')
@section('page-title','Create Notification')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
@endpush
@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Notification</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->
        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.notification')}}">
                        @csrf
                        <div class="card-body">
                            <div class="details-tab" style="border-bottom: none">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="subject" class="col-form-label control-label">Subject</label>
                                            <input type="text" class="form-control" name="subject" id="subject">
                                            @error('subject')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="description" class="col-form-label control-label">Description</label>
                                            <textarea id="description" class="form-control summernote"  rows="5" name="description" required>{{old('description')}}</textarea>
                                            @error('reason')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <div class="row">
                                                @error('permissions')
                                                <div class="col-md-12">
                                                </div>
                                                @enderror()
                                                <div class="col-sm-12">
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                    <label for="status" class="col-form-label control-label">Send to</label>
                                                    <select name="send_to" id="send_to" class="form-control notification" required>
                                                        <option value="" hidden></option>
                                                        <option value="all">All</option>
                                                        <option value="teams">Teams</option>
                                                        <option value="custom">Custom</option>
                                                    </select>
                                                    @error('send_to')
                                                    <span><strong class="text-danger">{{$message}}</strong></span>
                                                    @enderror()
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            <div class="form-group pmd-textfield pmd-textfield-floating-label teams" style="display: none">
                                <label for="user_id" class="col-form-label control-label">Teams</label>
                                <select name="team_id[]" id="team_id" class="form-control select-two" multiple>
                                    <option></option>
                                    @foreach($teams as $team)
                                        <option value="{{$team->id}}" >{{$team->title}}</option>
                                    @endforeach
                                </select>
                                @error('team_id')
                                <span><strong class="text-danger">{{$message}}</strong></span>
                                @enderror()
                            </div>

                            <div class="form-group pmd-textfield pmd-textfield-floating-label custom_user" style="display: none">
                                <label for="user_id" class="col-form-label control-label">Custom</label>
                                <select name="user_id[]" id="user_id" class="form-control select-two" multiple>
                                    <option></option>
                                    @foreach($users as $user)
                                        <option value="{{$user->id}}" >{{$user->name}}</option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                <span><strong class="text-danger">{{$message}}</strong></span>
                                @enderror()
                              </div>
                            </div>
                        </div>
                        <div class="card-footer pmd-card-border">
                            <div class="row">
                                <div class="col-md-12">
                                    <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script>
       $(document).ready(function() {
           $('.select-two').select2();
       });
       $(document).ready(function () {
           $('.notification').on('change',function () {
               var val = $(this).val();
               if(val == 'teams'){
                   $('.teams').css({'display':'block'});
                   $('.select2-container').css({'width':'100%'});
               }else{
                   $('.teams').css({'display':'none'});
               }
               if(val == 'custom'){
                   $('.custom_user').css({'display':'block'});
                   $('.select2-container').css({'width':'100%'});
               }else{
                   $('.custom_user').css({'display':'none'});
               }
           });
       });

       /*$(document).ready(function() {
           $('.summernote').summernote({
               height: 280,
               focus: false
           });
       });*/

    </script>
@endpush
