@extends('layouts.app')
@section('page-title','Projects')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.project') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.project')
                <a href="{{route('create.project')}}" class="btn btn-primary ">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <div id="accordion">
                        @foreach($project_types as $key => $type)
                            <div class="card">
                                <div class="card-header" id="heading{{$type->id}}">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse{{$type->id}}" aria-expanded="true" aria-controls="collapse{{$type->id}}">
                                            {{$type->title}}
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapse{{$type->id}}" class="collapse" aria-labelledby="heading{{$type->id}}" data-parent="#accordion">
                                    <div class="card-body">
                                        <p>
                                            <a href="{{route('team-work', base64_encode($type->id))}}" target="_blank" class="btn btn-success ">Team Work
                                                <i class="fa fa-external-link"></i>
                                            </a>
                                        </p>
                                        <table class="table pmd-table table-hover pmd-table-card datatable-project" id="TABLE_{{$type->id}}">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>S No.</th>
                                                <th>Title</th>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                                <th>Account Manager</th>
                                                <th>Project Manager</th>
                                                <th>Client Name</th>
                                                <th>Type</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $i = 1; ?>
                                            @foreach($projects[$key] as $value)
                                                <tr>
                                                    <td>{{$i++}}</td>
                                                    <td>
                                                        <a href="{{route('team-work.tasks', $value->id)}}" target="_blank">
                                                            {{$value->project_name}}
                                                        </a>
                                                    </td>
                                                    <td>{{$value->start_date}}</td>
                                                    <td>{{$value->end_date}}</td>
                                                    <td>{{$value->findAccountManager->name??"N/A"}}</td>
                                                    <td>{{$value->findProjectManager->name??"N/A"}}</td>
                                                    <td>{{$value->findClient->name??"N/A"}}</td>
                                                    <td>{{$value->findType->title??"N/A"}}</td>
                                                    <td>{{$value->findProjectStatus->title??"N/A"}}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                            @can('edit.project')
                                                            <a class="btn btn-primary" href="{{route('edit.project',['id'=>base64_encode($value->id)])}}" title='Edit'><i class="fa fa-pencil"></i></a>
                                                            @endcan
                                                            @can('delete.project')
                                                                <button class='btn btn-danger delete-btn' data-id='{{base64_encode($value->id)}}' title='Delete'><i class='fa fa-trash'></i> </button>
                                                            @endcan
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        var table;
        $(document).ready( function () {
            $('.select-two').select2();
            // $('.datatable-project').DataTable();
            var project_types_array = {{$project_types_array}}
            /*project_types_array.forEach(function(currentValue, index){
                console.log(currentValue)
                $('#TABLE_'+currentValue).DataTable();
                // setTimeout(function () {}, 2000)
            })*/

                function ajaxRequest (project_types_array) {
                    if (project_types_array.length > 0) {
                        var project_type_id = project_types_array.pop();
                        setTimeout(function () {
                            $('#TABLE_'+project_type_id).DataTable();
                        }, 1000)
                        ajaxRequest(project_types_array);
                    }
                }

            ajaxRequest(project_types_array);
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/project/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });

    </script>
@endpush
