@extends('layouts.app')
@section('page-title','Create Team')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Teams</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.team')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="title" class="col-form-label control-label">Team Title</label>
                                            <input type="text" class="form-control" name="title"
                                                   aria-describedby="emailHelp" id="title" value="{{old('title')}}" required>
                                            @error('title')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="team_head_user_id" class="col-form-label control-label">Team Head</label>
                                            <select name="team_head_user_id" id="team_head_user_id" class="form-control select-two" required>
                                                <option selected>Select Team Head</option>
                                                @foreach($users as $user)
                                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('team_head_user_id')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="team_member_user_id" class="col-form-label control-label">Team Members</label>
                                            <select name="team_member_user_id[]" id="team_member_user_id" class="form-control select-two" multiple>
{{--                                                <option></option>--}}
                                                @foreach($available_users as $user)
                                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('team_member_user_id')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status" class="col-form-label control-label">Status</label>
                                            <select name="status" id="status" class="form-control" required>
                                                <option value="" hidden></option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                            @error('status')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select-two').select2();
        });
    </script>
@endpush
