@extends('layouts.app')
@section('page-title','Notifications')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.notification') no-btn @endcannot">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.notification')
                <a href="{{route('create.notification')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>
    <!-- Modal -->
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title subject_title" id="exampleModalLongTitle" value="Title N/A"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body notification-list-scroll">
                        <div class="row">
                            <div class="col-sm-12 notification-description">
                                <p id="notification_description">
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Subject</th>
                                <th>Description</th>
                                <th>Notification from</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i=1; @endphp
                            @forelse($other_notifications as $notification)
                                <tr>
                                    <td>{{$i++ }}</td>
                                    <td>{{$notification->subject}}</td>
                                    <td>{!! (strlen($notification->description) >50 )?substr($notification->description,0,100)." ...":$notification->description !!}</td>
                                    <td>{{$notification->findUser->name??''}}</td>
                                    <td>
                                        <a class="btn btn-primary mark-as-read text-white"  data-id="{{$notification->id}}" data-toggle="modal" data-target="#exampleModalCenter"><i class="fa fa-eye" title="View"></i></a>
                                    </td>
                                </tr>
                            @empty
                            @endforelse

                            @foreach($generalNotifications as $gNotify)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $gNotify->gnotification->subject??'' }} </td>
                                    <td>{!! (strlen($gNotify->gnotification->description??'') >50 )?substr($gNotify->gnotification->description??'',0,100)." ...":$gNotify->gnotification->description??'' !!}</td>
                                    <td>{{ $gNotify->gnotification->findUser->name??'' }}</td>
                                    <td>
                                        <a class="btn btn-primary mark-as-read-general-notification"  data-id="{{$gNotify->id}}"
                                           data-toggle="modal" data-target="#exampleModalCenter">
                                            <i class="fa fa-eye text-white" title="View"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>
        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/notification/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });
        });
        $(document).on('click','.mark-as-read',function(){
            var $this = $(this);
            var id = $(this).attr('data-id');
            // alert(id)
            $.ajax({
                url: '{{URL::to('site/notification/mark-as-read')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    $(".modal-title").html(response.notification.subject??'N/A');
                    $('#notification_description').html(response.notification.description??'N/A');
                    $(".notification-description").css({"overflow":"auto","overflow-x":"hidden","max-height":"40vh","width":"100%"});
                    console.log(response.notification);
                }
            });
        });

        $(document).on('click','.mark-as-read-general-notification',function(){
            var $this = $(this);
            var id = $(this).attr('data-id');
           $.ajax({
                url: '{{URL::to('site/notification/mark-as-read-general-notification')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    $(".modal-title").html(response.notification.subject??'N/A');
                    $('#notification_description').html(response.notification.description??'N/A');
                    $(".notification-description").css({"overflow":"auto","overflow-x":"hidden","max-height":"40vh","width":"100%"});
                    console.log(response.notification);
                }
            });
        });

    </script>
@endpush
