@extends('layouts.app')
@section('page-title','Update Project')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

    <style>
        .outer_crcl {  }
        .outer-ul label { font-weight:700; margin:0; }
        .outer-ul li  { padding:5px 10px; }
        .outer-ul label input { margin-right:5px; }
        .user-p{
            background: aquamarine;
            border-radius: 5px;
            min-height: 52px;
        }

        .user-circle{
            background: coral;
            border-radius: 50%;
            padding: inherit;
            font-size: 13px;
            color: white; display: inline-block; width: 35px;
            text-align: center;
            height: 35px;
        }
        #clientModal .modal-dialog {
            max-width: 600px !important;
        }
    </style>
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Projects</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('update.project')}}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{$project->id}}">
                        <input type="hidden" id="users_to_notify" name="project_users" value="{{json_encode($project_users)}}">
                        <div class="card-body">

                            <!-- Basic Information -->
                            <div class="details-tab">
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="project_name" class="col-form-label control-label">Project Title</label>
                                            <input type="text" class="form-control" name="project_name"
                                                   aria-describedby="emailHelp" id="project_name" value="{{old('project_name')??$project->project_name}}" required>
                                            @error('project_name')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="start_date" class="col-form-label control-label">Start Date</label>
                                            <input type="text" class="form-control datepicker" name="start_date" id="start_date"
                                                   aria-describedby="emailHelp" value="{{old('start_date')??date('d-m-Y', strtotime($project->start_date))}}" required>
                                            @error('start_date')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="end_date" class="col-form-label control-label">End Date</label>
                                            <input type="text" class="form-control datepicker" name="end_date"
                                                   aria-describedby="emailHelp"
                                                   value="{{old('end_date')??date('d-m-Y', strtotime($project->end_date))}}" id="end_date" required>
                                            @error('end_date')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="description" class="col-form-label control-label">Description</label>
                                            <textarea id="description" class="form-control summernote"  rows="5" name="description">{{old('description')??json_decode($project->description)}}</textarea>
                                            @error('reason')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="account_manager_user_id">Account Manager</label>
                                            <select name="account_manager_user_id" id="account_manager_user_id" class="form-control select-two" required>
                                                <option value="" hidden></option>
                                                @foreach($users as $user)
                                                    <option value="{{$user->id}}" @if($project->account_manager_user_id == $user->id) selected @endif>{{$user->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('account_manager_user_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="project_manager_user_id">Project Manager</label>
                                            <select name="project_manager_user_id" id="project_manager_user_id" class="form-control select-two" required>
                                                <option value="" hidden></option>
                                                @foreach($users as $user)
                                                    <option value="{{$user->id}}" @if($project->project_manager_user_id == $user->id) selected @endif>{{$user->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('project_manager_user_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="client_id">Client Name</label>
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" id="toggle-client-modal-btn" type="button">Add Client</button>
                                            <select name="client_id" id="client_id" class="form-control select-two">
                                                <option value="" hidden></option>
                                                @foreach($clients as $client)
                                                    <option value="{{$client->id}}" @if($project->client_id == $client->id) selected @endif>{{$client->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('client_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="project_type_id">Project Type</label>
                                            <select name="project_type_id" id="project_type_id" class="form-control select-two" required>
                                                <option value="" hidden></option>
                                                @foreach($project_types as $type)
                                                    <option value="{{$type->id}}" @if($project->project_type_id == $type->id) selected @endif>{{$type->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('project_type_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="status_id">Project Status</label>
                                            <select name="status_id" id="status_id" class="form-control select-two" required>
                                                <option value="" hidden></option>
                                                @foreach($project_status as $status)
                                                    <option value="{{$status->id}}" @if($project->status_id == $status->id) selected @endif>{{$status->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('status')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <button type="button" class="btn btn-lg btn-success mt-4"
                                                    data-toggle="modal" data-target="#exampleModalCenter">Add Project Users
                                            </button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" data-backdrop="static" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Add Users</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="p-2 user-p outer_crcl">
                        @foreach($users as $user)
                            @if(in_array($user->id, $project_users))
                                <span class='user-circle' id='{{$user->id}}'>{{$user->firstname[0].$user->lastname[0]}}</span>
                            @endif
                        @endforeach
                    </p>
                    <input type="text" name="" id="search-user" class="form-control" placeholder="Search">
                    <ul class="list-group outer-ul" style="height: 400px; overflow: auto">
                        @foreach($users as $user)
                            <li class="list-group-item">
                                <label for="">
                                    <input type="checkbox" class="u" name=""
                                           data-short="{{$user->firstname[0].$user->lastname[0]}}"
                                           data-id="{{$user->id}}" value="{{$user->name}}"
                                           @if(in_array($user->id, $project_users)) checked @endif>{{$user->name}}
                                </label>
                            </li>
                        @endforeach

                    </ul>
                </div>
                <div class="modal-footer">
                    <span class="saved text-lg-center text-success" style="display: none;">Changes Saved</span>
                    <button type="button" class="btn btn-danger close-modal-btn" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary save-notify-users">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    {{--Modal For creating Client--}}
    <div id="clientModal" data-backdrop="static"  class="modal fade" tabindex="-1" role="dialog" aria-labelledby="clientModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="clientModalLabel">Add Client</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="add-client-form">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input name="firstname" id="firstname" type="text" class="form-control required" placeholder="First Name">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input name="lastname" id="lastname" type="text" class="form-control required" placeholder="Last Name">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input name="phone" id="phone" type="text" class="form-control required" placeholder="Phone">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input name="email" id="email" type="email" class="form-control required" placeholder="Email">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input name="password" id="password" type="password" class="form-control required" placeholder="Password">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="gender">Gender</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="gender" id="Male" value="Male" checked>
                                        <label class="form-check-label" for="Male">Male</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="Female" value="Female">
                                        <label class="form-check-label" for="Female">Female</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="marital_status">Marital Status</label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="marital_status" id="Married" value="Married" checked>
                                        <label class="form-check-label" for="Married">Married</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="marital_status" id="Unmarried" value="Unmarried">
                                        <label class="form-check-label" for="Unmarried">Unmarried</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="client_role_id">Role Permission</label>
                                    <select name="client_role_id" id="client_role_id" class="form-control">
                                        @foreach($roles as $role)
                                            <option value="{{$role->id}}">{{$role->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="client_status_id">Status</label>
                                    <select name="client_status_id" id="client_status_id" class="form-control">
                                        @foreach($user_status as $st)
                                            <option value="{{$st->id}}">{{$st->title}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <span id="message-success" class="badge badge-success d-none">Client Added Successfully</span>
                    <span id="message-error" class="badge badge-danger d-none">Something went Wrong</span>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="add-client-btn">Submit</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('.select-two').select2();
            $('#phone').mask("00000000000");

            $('.summernote').summernote({
                height: 280,
                focus: false
            });

            var dateToday = new Date();
            // Add start date date and time picker
            $('.datepicker').datetimepicker({
                // minDate: dateToday,
                format: 'DD-MM-YYYY'
            });
        });

        $(document).on('change', '#project_type_id', function(){
            let val = $(this).val()
            if(val !== ""){
                $.ajax({
                    url: '{{\Illuminate\Support\Facades\URL::to('get-project-status')}}' + '/' + val,
                    type: 'get',
                    success:function(res){
                        $('#status_id').html(res)
                    }
                })
            }else{
                $('#status_id').html('')
            }

        })

        $(document).on('click', '.u', function(){
            let ele = $(this)
            let id = ele.data('id')
            let short = ele.data('short')
            let checked = ele.is(":checked")

            if(checked){
                $('.user-p').append("<span class='user-circle' id='"+id+"'>"+short+"</span>");
            }else{
                $('.user-p').find('#'+id).remove()
            }
        })

        $(document).on('click', '.save-notify-users', function() {
            var elements = [];

            $('.u').each(function () {
                if(this.checked){
                    elements.push($(this).data('id'))
                }
            });

            $('.saved').show();
            $('#users_to_notify').val(JSON.stringify(elements));
        })

        $(document).on('click', '.close-modal-btn', function() {
            $('.saved').hide();
        })

        $('#search-user').keyup(function() {
            let search = $(this).val()
            let matches = $( 'ul.outer-ul' ).find( 'li:containsIN('+search+')' );
            $( 'li', 'ul.outer-ul' ).not( matches ).slideUp();
            matches.slideDown();
        })

        $(document).on('click', '#toggle-client-modal-btn', function () {
            $('#firstname').val('')
            $('#lastname').val('')
            $('#email').val('')
            $('#password').val('')
            $('#phone').val('')
            $('#message-success').addClass('d-none')
            $('#message-error').addClass('d-none')


            $('#clientModal').modal('show')
        })

        $(document).on('click', '#add-client-btn', function () {
            let error = orderFormValidation('#add-client-form', '.required')

            if (!error){
                let data = $('#add-client-form').serializeArray()
                $.ajax({
                    url: '{{route('insert.client.ajax')}}',
                    type: 'post',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        data:data,
                    },
                    success:function(res){
                        if (res.status === true){
                            $('#client_id').append(res.html)
                            $('#message-success').removeClass('d-none')
                        }else{
                            $('#message-error').removeClass('d-none')
                        }
                    }
                })
            }
        })

        function orderFormValidation(form_id, classvar) {
            let error = false;
            $(form_id).find(classvar).each(function (e) {
                let value = $(this).val();

                if (value == '') {
                    $(this).css('border','1px solid red');
                    error = true;
                } else {
                    $(this).css('border','1px solid green');
                }
            });

            return error;
        }

    </script>
@endpush
