@if($project_comments->count() > 0)
    @foreach($project_comments as $comment)
        <div class="read-comments" id="comment-{{$comment->id}}">
            @if(isset($comment->findUser->image))
                <img src="{{asset('employees/images/'.$comment->finduser->image)}}" style="border-radius: 50% !important; width: 75px !important; height: 75px; object-fit: fill;" alt="Avatar">
            @elseif(isset($comment->findUser))
                <span class="user-comment-circle">
                    {{substr($comment->findUser->firstname, 0, 1).substr($comment->findUser->lastname, 0, 1)}}
                </span>
            @else
                <span class="user-comment-circle">
                    {{"UU"}}
                </span>
            @endif
            <div class="author-sec">
                <a href="javascript:;" class="author-btn">{{$comment->findUser->name??''}}</a>
                <p class="comment-detail">
                    {!! json_decode($comment->description) !!}
                </p>
                <?php $project_files =  json_decode($comment->files); ?>
                @if($project_files != null)
                    @foreach($project_files as $file)
                        <?php
                        $exploded = explode('.', $file);

                        if ($exploded[1] == 'docx' || $exploded[1] == 'DOCX' || $exploded[1] == 'doc' ||
                            $exploded[1] == 'xlsx' || $exploded[1] == 'XLSX' ||
                            $exploded[1] == 'XLS' || $exploded[1] == 'xls' || $exploded[1] == 'xml') {
                            $urlPath = "https://view.officeapps.live.com/op/embed.aspx?src=".urlencode(URL::to('/') . '/public/team-work/project_files/'.$project->slug.'/comment_files/'.$file);
                        } else {
                            $urlPath = asset('team-work/project_files/'.$project->slug.'/comment_files/'.$file);
                        }
                        ?>

                        <p>
                            <a href="{{ $urlPath }}" class="fancybox"
                               data-fancybox
                               data-type="iframe"
                               data-preload="false"
                            >{{$file}}</a>
                        </p>
                    @endforeach
                @endif
            </div>
            <div class="comments-histroy">
                <h6 class="comments-time">{{\Carbon\Carbon::make($comment->created_at)->format('D M jS, h:i A')}}</h6>
                @if((auth()->check() && auth()->user()->is_admin) || (auth()->check() && (auth()->user()->id == $comment->user_id)))
                    <div class="dropdown history-dropdown">
                        <i class="fas fa-ellipsis-h" data-toggle="dropdown" aria-haspopup="true"
                           aria-expanded="false"></i>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <ul>
                                <li>
                                    <a class="dropdown-item delete-comment" href="javascript:void(0)" data-id="{{$comment->id}}">Delete</a>
                                    <a class="dropdown-item copy-link" href="javascript:void(0)" data-link="{{(route('team-work.tasks', [$project->id, 'c' => $comment->id]))}}">Copy Link</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @endforeach

@else
    <p>No Comments </p>
@endif
