@extends('layouts.app')
@section('page-title','User Status')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.user-status') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>

        <div>
            @can('create.user-status')
                <a href="{{route('create.user-status')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Title</th>
                                <th title="User with this status can access the site or not.">Has Access</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                             @php $i = 1; @endphp
                             @forelse($user_status as $status)
                                 <tr>
                                     <td>{{ $i++ }}</td>
                                     <td>{{$status->title}}</td>
                                     <td>
                                         @if($status->has_access == 1)
                                             <span class="badge badge-success">Yes</span>
                                         @else
                                             <span class="badge badge-danger">No</span>
                                         @endif
                                     </td>
                                     <td>
                                         @if($status->status == 1)
                                             <span class="badge badge-success">Active</span>
                                         @else
                                             <span class="badge badge-danger">In-Active</span>
                                         @endif
                                     </td>
                                     <td>
                                         <div class="btn-group">
                                             @can('edit.user-status')
                                                 <a class="btn btn-primary btn-style" href="{{route('edit.user-status',base64_encode($status->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                             @endcan
                                             @can('delete.user-status')
                                                 <button class="btn btn-danger delete-btn" data-id="{{base64_encode($status->id)}}" title="Delete"><i class="fa fa-trash"></i> </button>
                                             @endcan
                                         </div>
                                     </td>
                                 </tr>
                             @empty
                                 <tr>
                                     <td colspan="5" class="text-center">No User Status Available</td>
                                 </tr>
                             @endforelse
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>

        $(document).ready(function(){
           $('#roles-datatable').dataTable();
        });

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/user-status/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
