<?php $__env->startSection('page-title','User Details'); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="pmd-content inner-page profile-page">
        <div class="cover-content">
            <div class="page-content">
                <div class="d-flex d-flex-row align-items-center mobile-view">
                    <?php if($user->gender == 'Male'): ?>
                        <img alt="Profile-Pic" src="<?php echo e(asset(isset($user->image) ? 'employees/images/'.$user->image : 'themes/images/dummy.png')); ?>" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                    <?php else: ?>
                        <img alt="Profile-Pic" src="<?php echo e(asset(isset($user->image) ? 'employees/images/'.$user->image : 'themes/images/dummy-female.png')); ?>" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                    <?php endif; ?>
                    <div class="media-body">
                        <h1><?php echo e($user->name); ?></h1>
                        <p class="pmd-list-subtitle"><strong>Role: </strong><?php echo e(ucwords($user->findRole->name??'')); ?></p>
                        <p>Amorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vitae nibh nisl. Cras etitikis mauris eget lorem ultricies ferme ntum a inti diam. Amorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vitae nibh nisl. Cras etitikis mauris eget lorem ultricies ferme ntum a inti diam.</p>
                        <div class="pmd-social-icon">
                            <a class="btn btn-sm pmd-btn-fab pmd-ripple-effect btn-dark ml-0" href="javascript:void(0);" title="Facebook">
                                <svg version="1.1" x="0px" y="0px" viewBox="0 0 310 310" style="enable-background:new 0 0 310 310;" xml:space="preserve" class="svg replaced-svg replaced-svg">
								<g id="XMLID_834_">
                                    <path id="XMLID_835_" d="M81.703,165.106h33.981V305c0,2.762,2.238,5,5,5h57.616c2.762,0,5-2.238,5-5V165.765h39.064   c2.54,0,4.677-1.906,4.967-4.429l5.933-51.502c0.163-1.417-0.286-2.836-1.234-3.899c-0.949-1.064-2.307-1.673-3.732-1.673h-44.996   V71.978c0-9.732,5.24-14.667,15.576-14.667c1.473,0,29.42,0,29.42,0c2.762,0,5-2.239,5-5V5.037c0-2.762-2.238-5-5-5h-40.545   C187.467,0.023,186.832,0,185.896,0c-7.035,0-31.488,1.381-50.804,19.151c-21.402,19.692-18.427,43.27-17.716,47.358v37.752H81.703   c-2.762,0-5,2.238-5,5v50.844C76.703,162.867,78.941,165.106,81.703,165.106z"></path>
                                </g>
							</svg>
                            </a>
                            <a class="btn btn-sm pmd-btn-fab pmd-ripple-effect btn-dark" href="javascript:void(0);" title="Twitter">
                                <svg version="1.1" x="0px" y="0px" viewBox="0 0 310 310" style="enable-background:new 0 0 310 310;" xml:space="preserve" class="svg replaced-svg replaced-svg">
									<g id="XMLID_826_">
                                        <path id="XMLID_827_" d="M302.973,57.388c-4.87,2.16-9.877,3.983-14.993,5.463c6.057-6.85,10.675-14.91,13.494-23.73   c0.632-1.977-0.023-4.141-1.648-5.434c-1.623-1.294-3.878-1.449-5.665-0.39c-10.865,6.444-22.587,11.075-34.878,13.783   c-12.381-12.098-29.197-18.983-46.581-18.983c-36.695,0-66.549,29.853-66.549,66.547c0,2.89,0.183,5.764,0.545,8.598   C101.163,99.244,58.83,76.863,29.76,41.204c-1.036-1.271-2.632-1.956-4.266-1.825c-1.635,0.128-3.104,1.05-3.93,2.467   c-5.896,10.117-9.013,21.688-9.013,33.461c0,16.035,5.725,31.249,15.838,43.137c-3.075-1.065-6.059-2.396-8.907-3.977   c-1.529-0.851-3.395-0.838-4.914,0.033c-1.52,0.871-2.473,2.473-2.513,4.224c-0.007,0.295-0.007,0.59-0.007,0.889   c0,23.935,12.882,45.484,32.577,57.229c-1.692-0.169-3.383-0.414-5.063-0.735c-1.732-0.331-3.513,0.276-4.681,1.597   c-1.17,1.32-1.557,3.16-1.018,4.84c7.29,22.76,26.059,39.501,48.749,44.605c-18.819,11.787-40.34,17.961-62.932,17.961   c-4.714,0-9.455-0.277-14.095-0.826c-2.305-0.274-4.509,1.087-5.294,3.279c-0.785,2.193,0.047,4.638,2.008,5.895   c29.023,18.609,62.582,28.445,97.047,28.445c67.754,0,110.139-31.95,133.764-58.753c29.46-33.421,46.356-77.658,46.356-121.367   c0-1.826-0.028-3.67-0.084-5.508c11.623-8.757,21.63-19.355,29.773-31.536c1.237-1.85,1.103-4.295-0.33-5.998   C307.394,57.037,305.009,56.486,302.973,57.388z"></path>
                                    </g>
								</svg>
                            </a>
                            <a class="btn btn-sm pmd-btn-fab pmd-ripple-effect btn-dark" href="javascript:void(0);" title="LinkedIn">
                                <svg version="1.1" x="0px" y="0px" viewBox="0 0 310 310" style="enable-background:new 0 0 310 310;" xml:space="preserve" class="svg replaced-svg replaced-svg">
									<g id="XMLID_801_">
                                        <path id="XMLID_802_" d="M72.16,99.73H9.927c-2.762,0-5,2.239-5,5v199.928c0,2.762,2.238,5,5,5H72.16c2.762,0,5-2.238,5-5V104.73   C77.16,101.969,74.922,99.73,72.16,99.73z"></path>
                                        <path id="XMLID_803_" d="M41.066,0.341C18.422,0.341,0,18.743,0,41.362C0,63.991,18.422,82.4,41.066,82.4   c22.626,0,41.033-18.41,41.033-41.038C82.1,18.743,63.692,0.341,41.066,0.341z"></path>
                                        <path id="XMLID_804_" d="M230.454,94.761c-24.995,0-43.472,10.745-54.679,22.954V104.73c0-2.761-2.238-5-5-5h-59.599   c-2.762,0-5,2.239-5,5v199.928c0,2.762,2.238,5,5,5h62.097c2.762,0,5-2.238,5-5v-98.918c0-33.333,9.054-46.319,32.29-46.319   c25.306,0,27.317,20.818,27.317,48.034v97.204c0,2.762,2.238,5,5,5H305c2.762,0,5-2.238,5-5V194.995   C310,145.43,300.549,94.761,230.454,94.761z"></path>
                                    </g>
								</svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-content profile-view">
            <div class="row">
                <div class="col-12">
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <!-- About Tab -->
                        <div role="tabpanel" class="tab-pane active" id="about">
                            <div class="card pmd-card">
                                <div class="card-body">

                                    <!-- Basic Information -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">Basic Information</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">First Name</label>
                                                <p class="pmd-list-title"><?php echo e($user->firstname ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Last Name</label>
                                                <p class="pmd-list-title"><?php echo e($user->lastname ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Client Display Name</label>
                                                <p class="pmd-list-title"><?php echo e($user->client_display_name ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Phone</label>
                                                <p class="pmd-list-title"><?php echo e($user->phone ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Email</label>
                                                <p class="pmd-list-title"><a href="mailto: <?php echo e($user->email); ?>" title="<?php echo e($user->email); ?>"><?php echo e($user->email); ?></a></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Gender</label>
                                                <p class="pmd-list-title"><?php echo e($user->gender ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Marital Status</label>
                                                <p class="pmd-list-title"><?php echo e($user->marital_status ?? 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Rank</label>
                                                <p class="pmd-list-title"><?php echo e($user->findRank->title ?? 'N/A'); ?></p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Designation</label>
                                                <p class="pmd-list-title"><?php echo e($user->findDesignation->title ?? 'N/A'); ?></p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Job Title</label>
                                                <p class="pmd-list-title"><?php echo e($user->findJobTitle->title ?? 'N/A'); ?></p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Join Date</label>
                                                <p class="pmd-list-title"><?php echo e($user->join_date ?? 'N/A'); ?></p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">leave Date</label>
                                                <p class="pmd-list-title"><?php echo e($user->leaving_date ?? 'Continue'); ?> </p>
                                            </div>
                                            <?php if(isset($user->reason)): ?>
                                                <div class="col-12 col-md-6 col-lg-3">
                                                    <label class="pmd-list-subtitle">Reason To Leave</label>
                                                    <p class="pmd-list-title"><?php echo e($user->reason ?? ''); ?> </p>
                                                </div>
                                            <?php endif; ?>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Time Period</label>
                                                <p class="pmd-list-title"><?php echo e($workedTime); ?> </p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Role</label>
                                                <p class="pmd-list-title"><?php echo e($user->findRole->name ?? 'N/A'); ?></p>
                                            </div>

                                            <?php
                                            $start_time = '';
                                            $end_time = '';
                                            $shift = $user->findShift;
                                            if(!empty($shift)){
                                                $start_time = date('g:i a',strtotime($shift->start_time));
                                                $end_time = date('g:i a',strtotime($shift->end_time));
                                            }
                                            ?>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Shift</label>
                                                <p class="pmd-list-title"><?php echo e($user->findShift->title?('['.$start_time.' to '.$end_time.'] '.$shift->title) : 'N/A'); ?></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Teams</label>
                                                <?php $__empty_1 = true; $__currentLoopData = $user_teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <p class="pmd-list-title"><?php echo e($team); ?></p>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <p class="pmd-list-title"><?php echo e('N/A'); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Salary Details -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">Salary Details</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Basic Salary</label>
                                                <p class="pmd-list-title"><?php echo e($user->basic_salary); ?></p>
                                            </div>

                                            <?php $__empty_1 = true; $__currentLoopData = $allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <div class="col-12 col-md-6 col-lg-3">
                                                    <label class="pmd-list-subtitle"><?php echo e($allowance->title); ?></label>
                                                    <?php if(array_key_exists($allowance->id,$userAllowanceId)): ?>
                                                        <p class="pmd-list-title"><?php echo e($userAllowanceId[$allowance->id] ?? 'N/A'); ?></p>
                                                    <?php else: ?>
                                                        <p class="pmd-list-title">N/A</p>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Total Salary</label>
                                                <p class="pmd-list-title"><?php echo e($user->total_salary); ?></p>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Other Details -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">Other Details</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-3">
                                                <label class="pmd-list-subtitle">Status</label>
                                                <?php if($status = $user->findStatus): ?>
                                                    <p class="pmd-list-title <?php echo e($status->has_access ? 'text-success' : 'text-danger'); ?>"><?php echo e($status->title ?? ''); ?></p>
                                                <?php else: ?>
                                                    <p class="pmd-list-title"><?php echo e('N/A'); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('js/jquery-mask/src/jquery.mask.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('#phone').mask("00000000000",{placeholder:'N/A'});
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp\htdocs\laraveltwo\wamztech-crm\app2\resources\views/users/show.blade.php ENDPATH**/ ?>