<?php $__env->startSection('page-title','Project Status'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">

    <style>
        .change-position{
            cursor: pointer;
        }
    </style>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.project-status')): ?> no-btn <?php endif; ?>">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>

        <div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.project-status')): ?>
                <a href="<?php echo e(route('create.project-status')); ?>" class="btn btn-primary">Create</a>
            <?php endif; ?>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <div id="accordion">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $datum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card">
                                <div class="card-header" id="heading<?php echo e($datum[0]); ?>">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse<?php echo e($datum[0]); ?>" aria-expanded="true" aria-controls="collapse<?php echo e($datum[0]); ?>">
                                            <?php echo e($key); ?>

                                        </button>
                                    </h5>
                                </div>

                                <div id="collapse<?php echo e($datum[0]); ?>" class="collapse" aria-labelledby="heading<?php echo e($datum[0]); ?>" data-parent="#accordion">
                                    <div class="card-body">
                                        <table class="table pmd-table table-hover pmd-table-card datatable-project" id="TABLE_<?php echo e($datum[0]); ?>">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>S No.</th>
                                                <th>Title</th>
                                                <th>Project Type</th>
                                                <th>Sort Order</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $i = 1; ?>
                                            <?php $__empty_1 = true; $__currentLoopData = $datum[1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($i++); ?></td>
                                                    <td><?php echo e($status->title); ?></td>
                                                    <td><?php echo e($status->findType->title??""); ?></td>
                                                    <td>
                                                        <span class="badge badge-warning" >Sort:
                                                            <b size="4"><?php echo e($status->sort_order); ?></b>
                                                        </span>
                                                        <i class="fas fa-edit change-position" data-type="<?php echo e($status->project_type_id); ?>" data-id="<?php echo e($status->id); ?>" data-sort="<?php echo e($status->sort_order); ?>"></i></td>
                                                    <td>
                                                        <?php if($status->status == 1): ?>
                                                            <span class="badge badge-success">Active</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger">In-Active</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit.project-status')): ?>
                                                                <a class="btn btn-primary btn-style" href="<?php echo e(route('edit.project-status',base64_encode($status->id))); ?>" title="Edit"><i class="fa fa-edit"></i> </a>
                                                            <?php endif; ?>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete.project-status')): ?>
                                                                <button class="btn btn-danger delete-btn" data-id="<?php echo e(base64_encode($status->id)); ?>" title="Delete"><i class="fa fa-trash"></i> </button>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="5" class="text-center">No Project Status Available</td>
                                                </tr>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>

        $(document).ready(function() {
            $("table[id^='TABLE']").DataTable();
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(URL::to('site/project-status/delete')); ?>' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                 response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });

        $(document).on('click','.change-position',function (e) {
            var id = $(this).attr('data-id');
            var sort = $(this).attr('data-sort');
            var project_type_id = $(this).attr('data-type');
            Swal.fire({
                title: '<strong>Update Position</strong>',
                html:
                    ' <form role="form" action="<?php echo e(route('status.sort.position')); ?>" id="position-form" method="post" style="width: 100%">'+
                    '<?php echo csrf_field(); ?>
                        <div class="form-group col-md-12"><input type="number" class="form-control" id="position" name="position" required value="'+sort+'" placeholder="Enter Position Number"><input type="hidden" name="id" value="'+id+'"><input type="hidden" name="project_type_id" value="'+project_type_id+'"></div>'+
                    '</form>',
                showCloseButton: true,
                confirmButtonText: 'Upload',
                preConfirm: () => {
                    if (document.getElementById('position').value) {
                        // Handle return value
                    } else {
                        Swal.showValidationMessage('Position number is missing')
                    }
                }
            })
                .then((result) => {
                    if (result.isConfirmed)
                    {
                        $('#position-form').submit();
                    }
                })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/project-status/index.blade.php ENDPATH**/ ?>