<!-- Left sidebar -->
<aside id="basicSidebar"
       class="pmd-sidebar pmd-sidebar-dark pmd-sidebar-slide-push pmd-sidebar-open bg-primary pmd-z-depth-light-2"
       role="navigation">
    <ul class="nav flex-column pmd-sidebar-nav">

        <!-- User info -->
        <li class="nav-item pmd-user-info mb-0">
            <a href="javascript:void(0);" class="nav-link btn-user text-center">
                <?php if(auth()->user()->image): ?>
                    <img class="rounded-circle m-auto" src="<?php echo e(asset('employees/images/'.(auth()->user()->image))); ?>" width="40" height="40"
                         alt="avatar">
                <?php else: ?>
                    <img class="rounded-circle m-auto" src="<?php echo e(asset('themes/images/user-icon.jpg')); ?>" width="40" height="40"
                         alt="avatar">
                <?php endif; ?>
                <h3 class="pmd-title m-0"><?php echo e(auth()->user()->name ?? 'Propeller Admin'); ?></h3>
                <p class="pmd-subheading1 m-0"><?php echo e(auth()->user()->email ?? 'support@propeller.in'); ?></p>
            </a>
        </li>
        <!-- End user info -->

        <li class="nav-item">
            <a class="nav-link pmd-ripple-effect" href="<?php echo e(route('dashboard')); ?>">
                <i class="pmd-list-icon fa fa-dashboard"></i>
                <span class="media-body">Dashboard</span>
            </a>
        </li>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/project') || Request::is('site/project/create') || Request::is('site/project*')) {
                $collapsed = 'show';
            }elseif (Request::is('site/project-status') || Request::is('site/project-status/create')) {
                $collapsed = 'show';
            }elseif (Request::is('site/project-type') || Request::is('site/project-type/create')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#project-menu">
                    <i class="pmd-list-icon fa fa-bar-chart"></i>
                    <span class="media-body">Team Work</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="project-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/project') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('project')); ?>">Project List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project-type')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/project-type') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('project-type')); ?>">Project Type List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project-status')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/project-status') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('project-status')); ?>">Project Status List</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/client') || Request::is('site/client/create') || Request::is('site/client*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#client-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Clients</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="client-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/client') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('client')); ?>">Client List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.client')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/client/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.client')); ?>">Create Client</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/user') || Request::is('site/user/create') || Request::is('site/user/edit*') || Request::is('site/user/user-activity')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#employee-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Employees</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="employee-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('user')); ?>">Employee List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.user')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.user')); ?>">Create Employee</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user.activity')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user/user-activity') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('user.activity')); ?>">Employee Attendance Activity</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employee-salary')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/employee-salary') || Request::is('site/employee-salary/create') || Request::is('site/employee-salary*')) {
                $collapsed = 'show';
            }
            ?>

            <li class="nav-item <?php echo e(Request::is('site/employee-salary') ? 'nav-border' : ''); ?>">
                <a class="nav-link pmd-ripple-effect" href="<?php echo e(route('employee-salary')); ?>">
                    <i class="pmd-list-icon fas fa-money-bill"></i>
                    <span class="media-body">Salaries</span>
                </a>
            </li>

        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('loan')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/loan') || Request::is('site/loan/*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#loan-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">Loans
                        <?php if((auth()->user()->is_admin??'') && $new_loan_request_count > 0): ?> <?php echo e("(".$new_loan_request_count.")"); ?> <?php endif; ?>
                    </span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="loan-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('loan')): ?>

                        <li class="nav-item <?php echo e(Request::is('site/loan/requests') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('loan.pending')); ?>">
                                <?php if(auth()->check() && auth()->user()->is_admin): ?>
                                    New Requests
                                <?php else: ?>
                                    Pending Requests
                                <?php endif; ?>

                                <?php if((auth()->user()->is_admin??'') && $new_loan_request_count > 0): ?> <?php echo e("(".$new_loan_request_count.")"); ?> <?php endif; ?>
                            </a>
                        </li>

                        <li class="nav-item <?php echo e(Request::is('site/loan') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('loan')); ?>">Loan List</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-status')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/user-status') || Request::is('site/user-status/create') || Request::is('site/user-status*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#user-status-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">User Status</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="user-status-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-status')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user-status') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('user-status')); ?>">User Status List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.user-status')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user-status/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.user-status')); ?>">Create User Status</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-department')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/user-department') || Request::is('site/user-department/create') || Request::is('site/user-department*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#user-designation-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">User Department</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="user-designation-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-department')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user-department') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('user-department')); ?>">User Department List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.user-department')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/user-department/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.user-department')); ?>">Create User Department</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-title')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/job-title') || Request::is('site/job-title/create') || Request::is('site/job-title*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#job-title-menu">
                    <i class="pmd-list-icon fa fa-user-tag"></i>
                    <span class="media-body">Job Title</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="job-title-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job-title')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/job-title') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('job-title')); ?>">Job Title List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.job-title')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/job-title/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.job-title')); ?>">Create Job Title</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('allowance')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/allowance') || Request::is('site/allowance/create') || Request::is('site/allowance*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#allowance-menu">
                    <i class="pmd-list-icon fa fa-usd"></i>
                    <span class="media-body">Allowances</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="allowance-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('allowance')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/allowance') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('allowance')); ?>">Allowance List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.allowance')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/allowance/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.allowance')); ?>">Create Allowance</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/role') || Request::is('site/role/create') || Request::is('site/role*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#role-menu">
                    <i class="pmd-list-icon fa fa-shield"></i>
                    <span class="media-body">Roles</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="role-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/role') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('role')); ?>">Role List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.role')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/role/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.role')); ?>">Create Role</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permission')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/permission') || Request::is('site/permission/create') ) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#permission-menu">
                    <i class="pmd-list-icon fa fa-key"></i>
                    <span class="media-body">Permissions</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="permission-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permission')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/permission') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('permission')); ?>">Permission List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.permission')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/permission/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.permission')); ?>">Create Permission</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ip')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/ip') || Request::is('site/ip/create') || Request::is('site/ip*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#ip-menu">
                    <i class="pmd-list-icon fa fa-globe"></i>
                    <span class="media-body">IP Management</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="ip-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ip')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/ip') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('ip')); ?>">Ip List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.ip')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/ip/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.ip')); ?>">Create Ip</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shift')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/shift') || Request::is('site/shift/create') || Request::is('site/shift*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#shift-menu">
                    <i class="pmd-list-icon fa fa-clock-o"></i>
                    <span class="media-body">Shifts</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="shift-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shift')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/shift') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('shift')); ?>">Shift List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.shift')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/shift/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.shift')); ?>">Create Shift</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leave')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/leave') || Request::is('site/leave/create') || Request::is('site/leave/edit/*') ) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#leave-menu">
                    <i class="pmd-list-icon fa fa-wheelchair-alt"></i>
                    <span class="media-body">Leave Types</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="leave-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leave')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/leave') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('leave')); ?>">Leave Type List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.leave')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/leave/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.leave')); ?>">Create Leave Type</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('team')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/team') || Request::is('site/team/create') || Request::is('site/team*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#team-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Teams</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="team-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('team')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/team') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('team')); ?>">Team List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.team')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/team/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.team')); ?>">Create Team</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('rank')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/rank') || Request::is('site/rank/create') || Request::is('site/rank*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#rank-menu">
                    <i class="pmd-list-icon fa fa-level-up"></i>
                    <span class="media-body">Ranks</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="rank-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('rank')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/rank') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('rank')); ?>">Rank List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.rank')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/rank/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.rank')); ?>">Create Rank</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxslab')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/taxslab') || Request::is('site/taxslab/create') || Request::is('site/taxslab*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#taxslab-menu">
                    <i class="pmd-list-icon fa fa-bank"></i>
                    <span class="media-body">Tax Management</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="taxslab-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxslab')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/taxslab') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('taxslab')); ?>">Tax Slab List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.taxslab')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/taxslab/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.taxslab')); ?>">Create Tax Slab</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leave-management')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/leave-management') || Request::is('site/leave-management/create') || Request::is('site/leave-management*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#leave-management">
                    <i class="pmd-list-icon fa fa-calendar"></i>
                    <span class="media-body">Leave Requests</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="leave-management" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('leave-management')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/leave-management') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('leave-management')); ?>">All Requests</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification')): ?>
            <?php
            $collapsed = '';
            if (Request::is('site/notification') || Request::is('site/notification/create') || Request::is('site/notification/sent') || Request::is('site/notification*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#notification">
                    <i class="pmd-list-icon fa fa-bell"></i>
                    <span class="media-body">Notification</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="notification" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sent.notification')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/notification/sent') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('sent.notification')); ?>">Sent Notifications</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('received.notification')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/notification/received') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('received.notification')); ?>">Received Notifications</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.notification')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/notification/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.notification')); ?>">Create Notification</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('interview')): ?>

            <?php
            $collapsed = '';
            if (Request::is('site/interview') || Request::is('site/interview/create') || Request::is('site/interview*')) {
                $collapsed = 'show';
            }
            ?>
            <li class="nav-item">
                <a class="nav-link" data-toggle="collapse" href="#interview-menu">
                    <i class="pmd-list-icon fa fa-users"></i>
                    <span class="media-body">Interview</span>
                    <div class="media-right media-bottom"><i class="dic-more-vert dic"></i></div>
                </a>
                <ul class="collapse <?php echo e($collapsed); ?>" id="interview-menu" data-parent="#basicSidebar">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('interview')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/interview') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('interview')); ?>">Interview List</a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.interview')): ?>
                        <li class="nav-item <?php echo e(Request::is('site/interview/create') ? 'nav-border' : ''); ?>">
                            <a class="nav-link" href="<?php echo e(route('create.interview')); ?>">Create Interview</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </li>
        <?php endif; ?>

        <li class="nav-item">
            
            <a class="nav-link" id="logout_area">
                <i class="pmd-list-icon fa fa-power-off"></i>
                <span class="media-body" id="logout_btn">Logout</span>
                <form action="<?php echo e(route('logout', ['logout_type' => 'Normal Logout'])); ?>" method="post" id="logout_form">
                    <?php echo csrf_field(); ?>
                </form>
            </a>
            <ul class="collapse" id="logout-menu" data-parent="#basicSidebar">
                <?php if(auth()->check() && auth()->user()->is_admin): ?>
                    <li class="nav-item" style="color: white">
                        <a class="nav-link" id="logout_area">
                            <i class="pmd-list-icon fa fa-power-off"></i>
                            <span class="media-body" id="logout_btn">Logout</span>
                            <form action="<?php echo e(route('logout')); ?>" method="post" id="logout_form">
                                <?php echo csrf_field(); ?>
                            </form>
                        </a>
                    </li>
                <?php else: ?>
                  
                <?php endif; ?>
            </ul>
        </li>

    </ul>
</aside>
<!-- End Left sidebar -->

<?php $__env->startPush('js'); ?>
    <script>
        $('#logout_area').on('click', function () {
            $('#logout_form').submit()
        })

        $('#logout_area2').on('click', function () {
            $('#logout_form2').submit()
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\projects\xampp\htdocs\laraveltwo\wamztech-crm\app2\resources\views/layouts/includes/sidebar.blade.php ENDPATH**/ ?>