<?php $__env->startSection('page-title',$team_member->title); ?>
<?php $__env->startPush('css'); ?>
    <style>
        #month {
            position: absolute;
            left: 35%;
            z-index: 1;
        }

        section#employee {
            position: relative;
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right no-btn">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>

        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <label  id="month">Month &nbsp;
                        <input type="month" name="start" id="start" max="<?php echo e(now()->subMonth()->format('Y-m')); ?>" value="<?php echo e(now()->subMonth()->format('Y-m')); ?>"/>
                    </label>
                    <input type="hidden" name="team_id" id="team_id" value="<?php echo e($team_member->id??''); ?>">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Name</th>
                                <th>Basic Salary</th>
                                <th>Medical Allowance</th>
                                <th>Transportation Allowance</th>
                                <th>Mobile Allowance</th>
                                <th>Total Salary</th>
                                <th>Salary Tax</th>
                                <th>Payable Salary</th>
                                <th>Working Days</th>
                                <th>Over Time</th>
                                <th>Late In</th>
                                <th>Early Out</th>
                                <th>Unpaid Leave</th>
                                <th>Paid Leave</th>
                                <th>Loan Installment</th>
                                <th>Disbursed</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </section>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('js/jquery-mask/src/jquery.mask.js')); ?>"></script>
    <script>
        var team_id;
        $(document).ready(function () {
            team_id =  $('#team_id').val();

            var dataTables =  $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "<?php echo e(route('disbursed.history')); ?>",
                    "dataType": "json",
                    "type": "POST",
                    "data":function (data) {
                        var month = $('#start').val();
                        data.month = month;
                        data._token = "<?php echo e(csrf_token()); ?>";
                        data.id = team_id;
                    }
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "name",sortable:false},
                    {"data": "basic_salary",sortable:false},
                    {"data": "medical_allowance",sortable:false},
                    {"data": "transportation_allowance",sortable:false},
                    {"data": "mobile_allowance",sortable:false},
                    {"data": "total_salary",sortable:false},
                    {"data": "salary_tax",sortable:false},
                    {"data": "net_salary",sortable:false},
                    {"data": "working_days",sortable:false},
                    {"data": "over_time",sortable:false},
                    {"data": "mark_as_late",sortable:false},
                    {"data": "mark_as_early_out",sortable:false},
                    {"data": "unpaid_leave",sortable:false},
                    {"data": "paid_leave",sortable:false},
                    {"data": "loan_installment",sortable:false},
                    {"data": "updated_at",sortable:false},
                ]
            });

            $(document).on("change",'#month',function (e) {
                dataTables.draw();
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/user-salary/disbursed.blade.php ENDPATH**/ ?>