<?php $__env->startSection('page-title','Received Notifications'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.notification')): ?> no-btn <?php endif; ?>">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>
        <div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.notification')): ?>
                <a href="<?php echo e(route('create.notification')); ?>" class="btn btn-primary">Create</a>
            <?php endif; ?>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Sender</th>
                                <th>Subject</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i=1; ?>
                            <?php $__empty_1 = true; $__currentLoopData = $received_notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($notification->gnotification->findUser->name??"N/A"); ?></td>
                                    <td><?php echo e($notification->gnotification->subject??"N/A"); ?></td>
                                    <td>
                                        <?php if($notification->gnotification->description): ?>
                                            <?php echo e((strlen($notification->gnotification->description) >50 )?substr($notification->gnotification->description,0,100)." ...":$notification->gnotification->description); ?></td>
                                        <?php else: ?>
                                            <?php echo e("N/A"); ?>

                                        <?php endif; ?>
                                    <td>
                                        <?php if($notification->is_read): ?>
                                            <span class="badge badge-success">Seen</span>
                                        <?php else: ?>
                                            <div class="btn-html">
                                                <a class="btn btn-primary mark-as-read text-white" data-id="<?php echo e($notification->id); ?>" >Mark as Read</a>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">No Notification</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>

        $(document).on('click','.mark-as-read',function () {
           let ele = $(this);
           let id = ele.attr('data-id');
            ele.html('<i class="fa fa-spinner fa-spin"></i>')
            $.ajax({
                url: '<?php echo e(URL::to('site/notification/mark-as-read')); ?>' +"/"+ id,
                type: 'get',
                success: function(response){
                    if(response.response == true){
                        ele.parent().html('<span class="badge badge-success">Seen</span>')
                    }else{
                        ele.html('')
                        ele.html('Mark as Read')
                    }
                }
            });
        })
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-7.4\htdocs\wamztech-crm\resources\views/notifications/notification_received.blade.php ENDPATH**/ ?>