<?php $__env->startSection('page-title','Leave Requests'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="row">
            <div class="col-md-12">
                <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.leave-management')): ?> no-btn <?php endif; ?>">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pmd-breadcrumb mb-0">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.leave-management')): ?>
                        <?php if(auth()->id() !== 1): ?>
                            <a href="<?php echo e(route('create.leave-management')); ?>" class="btn btn-primary">Create</a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <?php if(auth()->id() === 1 || auth()->user()->role_id === 12): ?>
                                    <th>Employee Name</th>
                                <?php endif; ?>
                                <th>Leave Type</th>
                                <th>Reason</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Number of Leaves</th>
                                <th>Request Approval</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $leave_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($leave_request->id); ?></td>
                                    <?php if(auth()->id() === 1 || auth()->user()->role_id === 12): ?>
                                        <td><?php echo e($leave_request->findUser->name??""); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($leave_request->findLeaveType->title); ?></td>
                                    <td><?php echo e($leave_request->reason); ?></td>
                                    <td><?php echo e($leave_request->leave_from_date->format('D, jS F Y')); ?></td>
                                    <td><?php echo e($leave_request->leave_end_date->format('D, jS F Y')); ?></td>
                                    <td><?php echo e($leave_request->number_of_days); ?></td>
                                    
                                    <td class="req_approve_td">
                                        <?php
                                        $hr_approval = '';
                                        $tl_approval = '';
                                        if($leave_request->approved_by_hr) {
                                            $hr_approval = 'HR';
                                        }
                                        if($leave_request->approved_by_team_lead) {
                                            $tl_approval = 'TL';
                                        }
                                        ?>
                                        <?php if($hr_approval && $tl_approval): ?>
                                            <span class="badge badge-success"><?php echo e($hr_approval); ?></span>
                                            <span class="badge badge-success"><?php echo e($tl_approval); ?></span>
                                        <?php elseif((!$hr_approval) && (!$tl_approval)): ?>
                                            <span class="badge badge-warning"><?php echo e('pending'); ?></span>
                                            <div class="leave_approval_status">
                                                <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="<?php echo e($leave_request->id); ?>">
                                                    <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                </button>

                                                <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="<?php echo e($leave_request->id); ?>">
                                                    <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                </button>
                                            </div>
                                        <?php elseif($hr_approval || $tl_approval): ?>
                                            
                                            <span class="badge badge-warning"><?php echo e('Pending'); ?></span>
                                            <?php if(!$hr_approval && (auth()->user()->is_admin || auth()->user()->findRole->name == 'HR')): ?>
                                                <div class="leave_approval_status">
                                                    <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="<?php echo e($leave_request->id); ?>">
                                                        <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                    </button>

                                                    <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="<?php echo e($leave_request->id); ?>">
                                                        <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <span class="badge badge-success"><?php echo e($hr_approval); ?></span>
                                            <?php endif; ?>

                                            
                                            <?php if(!$tl_approval && !auth()->user()->isTeamLead->isEmpty()): ?>
                                                <div class="leave_approval_status">
                                                    <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="<?php echo e($leave_request->id); ?>">
                                                        <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                    </button>

                                                    <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="<?php echo e($leave_request->id); ?>">
                                                        <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <span class="badge badge-success"><?php echo e($tl_approval); ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    
                                    <td>
                                        <?php if($leave_request->status == 'Rejected'): ?>
                                            <span class="badge badge-danger"><?php echo e('Rejected'); ?></span>
                                        <?php elseif($leave_request->status == 'Approved'): ?>
                                            <span class="badge badge-success"><?php echo e('Approved'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-warning"><?php echo e('Pending'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="d-flex">
                                        <?php if(($leave_request->status == 'Pending' && $leave_request->user_id == auth()->id()) || auth()->id() == 1): ?>
                                            <div class="btn-group">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit.leave-management')): ?>
                                                    <a class="btn btn-primary btn-style" href="<?php echo e(route('edit.leave-management',base64_encode($leave_request->id))); ?>" title="Edit"><i class="fa fa-edit"></i> </a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete.leave-management')): ?>
                                                    <button class="btn btn-danger delete-btn" data-id="<?php echo e(base64_encode($leave_request->id)); ?>" title="Delete"><i class="fa fa-trash"></i> </button>
                                                <?php endif; ?>
                                            </div>
                    <?php endif; ?>
                </div>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php if(auth()->id() === 1 || (isset(auth()->user()->findRole->name) && auth()->user()->findRole->name == 'HR')): ?>
                        <tr>
                            <td colspan="10" class="text-center">No Requests Made</td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td colspan="9" class="text-center">No Requests Made</td>
                        </tr>
                        <?php endif; ?>
                        <?php endif; ?>
                        </tbody>
                        </table>
                        </section>
                </div>
            </div>
        </div>

</div>
<!-- content area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
$(document).ready( function () {
    $('#roles-datatable').DataTable({
        "order": [[ 0, "desc" ]]
    });
});

$(document).on('click','.delete-btn',function(){
    var id = $(this).attr('data-id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '<?php echo e(URL::to('site/leave-management/delete')); ?>' +"/"+ id,
                type: 'get',
                success: function(response){
                    Swal.fire(
                        'Deleted!',
                        response,
                        'success'
                    );
                    location.reload();
                }
            });
        }
    });
});

$(document).on('click','.leave_approval_status_btn',function(){
    var action = $(this).attr('data-action');
    var id = $(this).attr('data-id');
    var $this = $(this);

    Swal.fire({
        title: 'Are you sure?',
        text: "You want to "+action+" this request?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '<?php echo e(URL::to('site/leave-management/update-hr-status')); ?>',
                type: 'POST',
                data: {
                    'action':action,
                    'id': id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response){
                    if(response.error) {
                        Swal.fire(
                            response.message,
                            '',
                            'error'
                        );
                    }else {
                        Swal.fire(
                            response.message,
                            '',
                            'success'
                        );
                        $this.parent('.leave_approval_status').hide();

                        var res_by = '';
                        if(response.action == 'approved_by_hr') {
                            res_by = 'HR';
                        }else if(response.action == 'approved_by_team_lead') {
                            res_by = 'TL';
                        }
                        $this.parent('td').html('<span class="badge badge-success">'+res_by+'</span>');
                    }
                }
            });
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/leave_requests/index.blade.php ENDPATH**/ ?>