<?php $__env->startSection('page-title','User Status'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center"><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('create.user-status')): ?> no-btn <?php endif; ?>">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
                </ol>
            </nav>
        </div>

        <div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create.user-status')): ?>
                <a href="<?php echo e(route('create.user-status')); ?>" class="btn btn-primary">Create</a>
            <?php endif; ?>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Title</th>
                                <th title="User with this status can access the site or not.">Has Access</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                             <?php $i = 1; ?>
                             <?php $__empty_1 = true; $__currentLoopData = $user_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                 <tr>
                                     <td><?php echo e($i++); ?></td>
                                     <td><?php echo e($status->title); ?></td>
                                     <td>
                                         <?php if($status->has_access == 1): ?>
                                             <span class="badge badge-success">Yes</span>
                                         <?php else: ?>
                                             <span class="badge badge-danger">No</span>
                                         <?php endif; ?>
                                     </td>
                                     <td>
                                         <?php if($status->status == 1): ?>
                                             <span class="badge badge-success">Active</span>
                                         <?php else: ?>
                                             <span class="badge badge-danger">In-Active</span>
                                         <?php endif; ?>
                                     </td>
                                     <td>
                                         <div class="btn-group">
                                             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit.user-status')): ?>
                                                 <a class="btn btn-primary btn-style" href="<?php echo e(route('edit.user-status',base64_encode($status->id))); ?>" title="Edit"><i class="fa fa-edit"></i> </a>
                                             <?php endif; ?>
                                             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete.user-status')): ?>
                                                 <button class="btn btn-danger delete-btn" data-id="<?php echo e(base64_encode($status->id)); ?>" title="Delete"><i class="fa fa-trash"></i> </button>
                                             <?php endif; ?>
                                         </div>
                                     </td>
                                 </tr>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                 <tr>
                                     <td colspan="5" class="text-center">No User Status Available</td>
                                 </tr>
                             <?php endif; ?>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>

        $(document).ready(function(){
           $('#roles-datatable').dataTable();
        });

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo e(URL::to('site/user-status/delete')); ?>' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/user-status/index.blade.php ENDPATH**/ ?>