<?php $__env->startSection('page-title','Create Notification'); ?>
<?php $__env->startPush('css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Notification</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
            </ol>
        </nav>
        <!--breadcrumb end-->
        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="<?php echo e(route('insert.notification')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="details-tab" style="border-bottom: none">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="subject" class="col-form-label control-label">Subject</label>
                                            <input type="text" class="form-control" name="subject" id="subject">
                                            <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="description" class="col-form-label control-label">Description</label>
                                            <textarea id="description" class="form-control summernote"  rows="5" name="description" required><?php echo e(old('description')); ?></textarea>
                                            <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <div class="row">
                                                <?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="col-md-12">
                                                </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                <div class="col-sm-12">
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                    <label for="status" class="col-form-label control-label">Send to</label>
                                                    <select name="send_to" id="send_to" class="form-control notification" required>
                                                        <option value="" hidden></option>
                                                        <option value="all">All</option>
                                                        <option value="teams">Teams</option>
                                                        <option value="custom">Custom</option>
                                                    </select>
                                                    <?php $__errorArgs = ['send_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            <div class="form-group pmd-textfield pmd-textfield-floating-label teams" style="display: none">
                                <label for="user_id" class="col-form-label control-label">Teams</label>
                                <select name="team_id[]" id="team_id" class="form-control select-two" multiple>
                                    <option></option>
                                    <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($team->id); ?>" ><?php echo e($team->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['team_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group pmd-textfield pmd-textfield-floating-label custom_user" style="display: none">
                                <label for="user_id" class="col-form-label control-label">Custom</label>
                                <select name="user_id[]" id="user_id" class="form-control select-two" multiple>
                                    <option></option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" ><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                              </div>
                            </div>
                        </div>
                        <div class="card-footer pmd-card-border">
                            <div class="row">
                                <div class="col-md-12">
                                    <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Create</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script>
       $(document).ready(function() {
           $('.select-two').select2();
       });
       $(document).ready(function () {
           $('.notification').on('change',function () {
               var val = $(this).val();
               if(val == 'teams'){
                   $('.teams').css({'display':'block'});
                   $('.select2-container').css({'width':'100%'});
               }else{
                   $('.teams').css({'display':'none'});
               }
               if(val == 'custom'){
                   $('.custom_user').css({'display':'block'});
                   $('.select2-container').css({'width':'100%'});
               }else{
                   $('.custom_user').css({'display':'none'});
               }
           });
       });

       /*$(document).ready(function() {
           $('.summernote').summernote({
               height: 280,
               focus: false
           });
       });*/

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/internalportal/public_html/resources/views/notifications/create.blade.php ENDPATH**/ ?>