<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Api\Lead;
use App\Models\Api\LogoBillingForm;
use App\Models\Api\LogoBriefForm;
use App\Models\Api\WebsiteBriefForm;
use App\Models\ClientsInformation;
use App\Models\UserToComment;
use App\Models\Team;
use App\Models\TeamToMember;
use App\Models\User;
use App\Models\UserAllowanceInfo;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class LeadUserController extends Controller
{
    public function storeLead(Request $request){

        $validator = Validator([
            'firstname' => 'required|string',
            'lastname' => 'required|string',
            'email' => 'required',
            'password' => 'required',
            'phone' => 'required',
            'gender' => 'required',
            'marital_status' => 'required',
            'client_role_id' => 'required',
            'client_status_id' => 'required',
        ]);



        if ($validator->fails()){
            $res['status'] = false;
            $res['errors'] = $validator->errors();
        }else{

//            $request->merge(['password' => Hash::make($request->password)]);
//            $request->merge(['name' => $request->firstname.' '.$request->lastname]);

            $leadData = [
                'user_type_id' 			=>	$request->user_type_id,
                'role_id' 				=>	$request->role_id,
                'status_id' 			=>	$request->status_id,
                'name'					=>	$request->name,
                'firstname'				=>	$request->firstname,
                'client_display_name'	=>	$request->client_display_name,
                'email'					=>	$request->email,
                'password'              =>  Hash::make($request->password),
                'basic_salary'			=>	$request->basic_salary,
                'total_salary'			=>	$request->total_salary,
                'gender'				=>	$request->gender,
                'marital_status'		=>	$request->marital_status,
                'phone'		            =>	$request->phone,
                'join_date'				=>	$request->join_date,
                'ip_address'			=>	$request->ip_address,
                'country'				=>	$request->country,
                'city'					=>	$request->city,
                'state'					=>	$request->state,
                'time_zone'				=>	$request->time_zone,
                'postal_code'			=>	$request->postal_code,
                'sub_division'			=>	$request->sub_division,
                'isp'					=>	$request->isp,
                'user_package_display'	=>	$request->user_package_display,
                'brand_for'				=>	$request->brand_for
            ];

//            if ($request->hasFile('file')){
//
//                $fileName = $request->file->getClientOriginalName();
//                $request->file->move(public_path('employees/images'), $fileName);
//                $request->merge(['image' => $fileName]);
//
//            }

            $client     =   User::create($leadData);

            $lead_data  =   [
                                'user_id'       =>  $client->id,
                                'client_type'   =>  'Lead',
                                'sale_type'     =>  $request->pkg_name,
                                'project_type'  =>  $request->project_type,
                                'source'        =>  'Wesbite Inquiry Form'
                            ];
            $leads      =   Lead::create($lead_data);
            $msg        =   "User saved successfully";
            $res        =   [
                                'user_id'   =>  $client->id,
                                'message'   =>  $msg,
                                'user'      =>  $client,
                            ];
                            
            $comments   =   UserToComment::create([
                                'user_id'   => $client->id,
                                'comments'  => 'Popup form Filled By '.$request->firstname,
                            ]);
        }

        $lead_data= [
            'status'=>true,
            'data'=>$res,
            'mes'=>'Data get Success'
        ];

        return response()->json($lead_data);

    }

    public function website_brief(Request $request)
    {
        $validator = Validator([
            'user_id'                   => 'required',
            'firstname'                 => 'required|string',
            'email'                     => 'required',
            'phone'                     => 'required',
            'web_url'                   => 'required',
            'website_current_web_host'  => 'required'
        ]);

        if ($validator->fails()){
            $res['status'] = false;
            $res['errors'] = $validator->errors();
        }else{

//            $WebsiteBriefData = [
//                'user_id' 						=>	2,
//                'name'							=>	'Name',
//                'email'							=>	'abqqqqqc@example.com',
//                'phone'							=>	'abc@example.com123',
//                'type'							=>	$_POST["type"],
//			      'pkg'							    =>	$_POST["pkg"],
//                'current_website_url'			    =>	'current_website_url',
//                'current_web_host'				=>	'current_web_host',
//                'domain_already_purchased'		=>	'domain_already_purchased',
//                'providing_website_images'		=>	'providing_website_images',
//                'available_content'				=>	'available_content',
//                'company_desc'					=>	'company_desc',
//                'specific_theme'				=>	'specific_theme',
//                'colors'						=>	'colors',
//                'admire_by'						=>	'admire_by',
//                'additional_details'			=>	'additional_details',
//                'pages'					=>	'need_pages',
//                'website_services'				=>	'website_services',
//                'better_than_competition'		=>	'better_than_competition',
//                'customer_attraction'			=>	'customer_attraction',
//                'participate_by_socialmedia'	=>	'participate_by_socialmedia',
//            ];

//            if ($request->hasFile('file')){
//
//                $fileName = $request->file->getClientOriginalName();
//                $request->file->move(public_path('employees/images'), $fileName);
//                $request->merge(['image' => $fileName]);
//
//            }

            $websitebriefform     =   ClientsInformation::create($request->all());

            $msg        =   "Website Brief Form saved successfully";
            $res        =   [
                'websitebriefform_id'   =>  $websitebriefform->id,
                'message'               =>  $msg,
                'websitebriefform'      =>  $websitebriefform,
            ];
                            
            $comments   =   UserToComment::create([
                                'user_id'   => $request->user_id,
                                'comments'  => 'Website Brief form Filled By '.$request->firstname,
                            ]);
        }

        $website_brief_data= [
            'status'=>true,
            'data'=>$res,
            'mes'=>'Data get Success'
        ];

        return response()->json($website_brief_data);
    }

    public function logo_brief(Request $request)
    {
        $validator = Validator([
            'user_id'                   =>  'required',
            'firstname'                 =>  'required|string',
            'email'                     =>  'required',
            'phone'                     =>  'required',
            'logo_exact_name'	        =>	'required',
            'logo_slogan'		        =>	'required',
            'look_and_feel'	            =>	'required',
            'logo_competitor_ref'       =>	'required',
            'logo_primary_color'		=>	'required',
            'logo_secondary_color'	    =>	'required',
            'logo_industry'	            =>	'required',
            'logo_targeted_audience'	=>	'required',
            'logo_typography'		    =>	'required',
            'logo_type'			        =>	'required',
            'logo_pkg_price'			=>	'required'
        ]);

        if ($validator->fails()){
            $res['status'] = false;
            $res['errors'] = $validator->errors();
        }else{
//            $files_uploaded =[];
//            $slug = $request->name . " on " . date("Y-m-d H-i-s") . '-' . rand(0,10);
//
//            if ($request->file)
//            {
//                if (!is_dir('public/uploads/'.$slug)) {
//                    mkdir('public/uploads/' . $slug, 0777, TRUE);
//                }
//
//                if(!empty($request->file['name']))
//                {
//                    $filesCount = count($request->file['name']);
//                    for($i = 0; $i < $filesCount; $i++)
//                    {
//                        $path = $request->file['name'][$i];
//
//                        $ext = pathinfo($path, PATHINFO_EXTENSION);
//
//                        // File upload configuration
//                        $uploadPath = "uploads/$slug/";
//
//                        $fileName = time() . "-" . rand(1,1000) . ".$ext";
//
//                        $request->file->move(public_path($uploadPath), $fileName);
//
//                        $files_uploaded[]   =   $uploadPath . $fileName;
//                    }
//                }
//            }
//
//            echo "<pre>";
//            print_r($files_uploaded);
//            exit;
//            $request->merge(['reference_logos' => serialize($files_uploaded)]);

            $logobriefform     =   ClientsInformation::create($request->all());

            $msg        =   "Logo Brief Form saved successfully";
            $res        =   [
                'logobriefform_id'   =>  $logobriefform->id,
                'message'            =>  $msg,
                'logobriefform'      =>  $logobriefform,
            ];
                            
            $comments   =   UserToComment::create([
                                'user_id'   => $request->user_id,
                                'comments'  => 'Logo Brief form Filled By '.$request->firstname,
                            ]);
        }

        $logo_brief_data= [
            'status'=>true,
            'data'=>$res,
            'mes'=>'Data get Success'
        ];

        return response()->json($logo_brief_data);
    }

    public function logo_billing(Request $request)
    {
        $validator = Validator([
            'user_id'			=>	'required',
			'billing_package'	=>	'required',
			'billing_amount'	=>	'required',
			'cardholder_name'	=>	'required',
			'credit_card_number'=>	'required',
			'credit_card_cvc'   =>	'required',
			'month'	            =>	'required',
			'year'	            =>	'required',
			'credit_card_zip'	=>	'required'
        ]);

        if ($validator->fails()){
            $res['status'] = false;
            $res['errors'] = $validator->errors();
        }else{

            $logobillingform     =   ClientsInformation::where('user_id',$request->user_id)->update($request->all());

            $msg        =   "Logo Billing Form saved successfully";
            $res        =   [
                'message'               =>  $msg,
                'logobillingform'       =>  $logobillingform,
            ];
               
            $comments   =   UserToComment::create([
                                'user_id'   => $request->user_id,
                                'comments'  => 'Billing Form Filled',
                            ]);
        }

        $logo_billing_data= [
            'status'=>true,
            'data'=>$res,
            'mes'=>'Data get Success'
        ];

        return response()->json($logo_billing_data);
    }
}
