<?php

namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Role;
use App\Models\User;
use App\Models\UserStatus;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class ClientController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('clients.index');
    }

    public function showAllClients(Request $request){

        $columns_list = array(
            0 => 'id',
            7 => 'name',
            9 => 'email',
            20=> 'phone',
            5 => 'join_date',
            22=> 'image',
            16=> 'status_id',
        );

        $totalDataRecord = User::where('user_type_id',2)->count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'users.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = User::where('user_type_id',2)->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  User::where('id','LIKE',"%{$search_text}%")
                ->orWhere('name', 'LIKE',"%{$search_text}%")
                ->orWhere('email', 'LIKE',"%{$search_text}%")
                ->orWhere('phone', 'LIKE',"%{$search_text}%")
                ->orWhere('join_date', 'LIKE',"%{$search_text}%")
                ->orWhere('status_id', 'LIKE',"%{$search_text}%")
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = User::where('id','LIKE',"%{$search_text}%")
                ->orWhere('name', 'LIKE',"%{$search_text}%")
                ->orWhere('email', 'LIKE',"%{$search_text}%")
                ->orWhere('phone', 'LIKE',"%{$search_text}%")
                ->orWhere('join_date', 'LIKE',"%{$search_text}%")
                ->orWhere('status_id', 'LIKE',"%{$search_text}%")
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $color_class = (($post_val->findStatus->title??'') == 'Active') ? 'badge-success' : 'badge-danger';
                $i++;
                $deletedata = $post_val->id;
                $id =  base64_encode($deletedata);
                $showdata = route('show.client',['id'=>$id]);
                $dataedit =  route('edit.client',['id'=>$id]);
                $status = "<span class='badge ".$color_class."'>".$post_val->findStatus->title."</span>";
                $img = asset('employees/images/'.$post_val->image);

                $show_client = Gate::allows("show.client")?"<a class='btn btn-success btn-style' href='{$showdata}' title='View'><i class='fa fa-eye'></i> </a>":"";
                $delete_client = Gate::allows("delete.client")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_client = Gate::allows("edit.client")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['name'] = $post_val->name;
                $postnestedData['email'] = $post_val->email;
                $postnestedData['phone'] = $post_val->phone??'N/A';
                $postnestedData['join_date'] = $post_val->join_date??'N/A';
                $postnestedData['image'] = ($post_val->image)?"<img src='".$img."' width='80px' class='rounded mx-auto d-block'>":'N/A';
                $postnestedData['status_id'] = $status;
                $postnestedData['options'] = "<div class='btn-group'> {$show_client} {$edit_client} {$delete_client} </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        $roles = Role::where('name', 'Client')->get();
        $status = UserStatus::where('status', 1)->where(function ($query){
          $query->where('title', 'Active')->orWhere('title', 'Blocked');
        })->orderBy('title')->get();

        return view('clients.create', compact('roles', 'status'));
    }

    public function storeAjax(Request $request){
        $data = [];
        foreach ($request->data as $key => $value){
            $data[$value['name']] = $value['value'];
        }
        $res['status'] = true;
        $validator = Validator::make($data, [
            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'password' => 'required',
            'phone' => 'required',
            'gender' => 'required',
            'marital_status' => 'required',
            'client_role_id' => 'required',
            'client_status_id' => 'required',
        ]);

        if ($validator->fails()){
            $res['status'] = false;
            $res['errors'] = $validator->errors();
        }else{

            $data['user_type_id'] = 2; //This determines user is a client
            $data['name'] = $data['firstname'].' '.$data['lastname'];
            $data['client_display_name'] = $data['firstname'].' '.$data['lastname'];
            $data['join_date'] = Carbon::now()->format('d-m-Y');
            $data['password'] = Hash::make($data['password']);
            $data['role_id'] = $data['client_role_id'];
            $data['status_id'] = $data['client_status_id'];

            $client = User::create($data);
            $html = "<option value='".$client->id."'>".$client->name."</option>";
            $res['html'] = $html;
        }

        return response()->json($res);

    }

    public function store(Request $request){

        $request->validate([
            'firstname'             => 'required|string',
            'lastname'              => 'required|string',
            'email'                 => 'required|email|unique:users',
            'password'              => 'required|min:4',
            'gender'                => 'required',
            'role_id'               => 'required|string',
            'status_id'             => 'required',
        ]);

        $request->merge([
            'user_type_id' => 2, //This determines user is a client
            'name' => $request->firstname.' '.$request->lastname,
            'client_display_name' => $request->firstname.' '.$request->lastname,
            'join_date' => Carbon::now()->format('d-m-Y'),
            'password' => Hash::make($request->password)
        ]);

        if ($request->hasFile('file')){
            $fileName = $request->file->getClientOriginalName();
            $request->file->move(public_path('employees/images'), $fileName);
            $request->merge(['image' => $fileName]);
        }

        User::create($request->all());
        return redirect()->route('client')->with('mesg', 'Client created successfully');

    }

    public function edit($id){
        $client = User::find(base64_decode($id));
        if ($client){
            $roles = Role::where('name', 'Client')->get();
            $status = UserStatus::where('status', 1)->where(function ($query){
                $query->where('title', 'Active')->orWhere('title', 'Blocked');
            })->orderBy('title')->get();

            return view('clients.edit', compact('roles', 'status', 'client'));
        }else{
            return redirect()->back()->with('error','Client not found.');
        }
    }

    public function show($id){
        $client = User::find(base64_decode($id));
        if (!$client)
            return redirect()->back()->with('error', 'Client not found');

        $projects = Project::where('client_id', $client->id)->get();

        return view('clients.show', compact('client', 'projects'));
    }

    public function update(Request $request){

        $request->validate([
            'firstname' => 'required|string',
            'lastname'  => 'required|string',
            'email'     => 'required|email|unique:users,email,'.$request->id,
            'gender'    => 'required',
            'role_id'   => 'required|string',
            'status_id' => 'required',
        ]);

        $request->merge([
            'name' => $request->firstname.' '.$request->lastname,
            'client_display_name' => $request->firstname.' '.$request->lastname,
        ]);

        if ($request->hasFile('file')){
            $fileName = $request->file->getClientOriginalName();
            $request->file->move(public_path('employees/images'), $fileName);
            $request->merge(['image' => $fileName]);
        }

        $client = User::find($request->id);
        if ($client){
            $res = $client->update($request->all());
            if ($res){
                return redirect()->route('client')->with('mesg','Client updated successfully.');
            }
        }
    }

    public function delete($id){
    }

}
