<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\ClientsInformation;
use App\Models\Country;
use App\Models\LeadsToClient;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Role;
use App\Models\State;
use App\Models\User;
use App\Models\UserStatus;
use App\Models\UserToComment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use function GuzzleHttp\Promise\all;
use Slack;
class ClientsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        date_default_timezone_set("Asia/Karachi");

    }

    public function index(){
        return view('new-clients.index');
    }

    public function showClients(Request $request)
    {
        $columns_list = [
            'id',
            'name',
            'email',
            'phone',
            'sale_type',
            'status_id',
        ];

        $baseQuery = User::select('users.*')
            ->join('leads_to_clients', 'users.id', '=', 'leads_to_clients.user_id')
            ->where('leads_to_clients.client_type', 'Client');

        $totalDataRecord = $baseQuery->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length', 10);
        $start_val = $request->input('start', 0);
//        $orderColumn = $columns_list[$request->input('order.0.column')] ?? 'id';
//        $dir_val = $request->input('order.0.dir', 'desc');

        $query = $baseQuery->orderBy('id','DESC');

        if ($searchText = $request->input('search.value')) {
            if ($searchText == 'Active' || $searchText == 'In-Active') {
                $searchText = ($searchText == 'Active') ? '1' : '0';
            }

            $query->where(function($q) use ($searchText) {
                $q->where('users.id', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.name', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.email', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.phone', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.join_date', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.status_id', 'LIKE', "%{$searchText}%");
            });

            $totalFilteredRecord = $query->count();
        }

        $post_data = $query->offset($start_val)
            ->limit($limit_val)
            ->orderBy('id','DESC')
            ->get();
//        dd($post_data);
        $data_val = [];
        if ($post_data->isNotEmpty()) {
            foreach ($post_data as $index => $post_val) {
                if ($post_val->findLead->client_status == 'Sale') {
                    $color_class = 'badge-primary';
                }elseif ($post_val->findLead->client_status == 'Upsell'){
                    $color_class = 'badge-secondary';
                }elseif ($post_val->findLead->client_status == 'Recurring'){
                    $color_class = 'badge-success';
                }elseif ($post_val->findLead->client_status == 'Returning'){
                    $color_class = 'badge-warning';
                }elseif ($post_val->findLead->client_status == 'Referral'){
                    $color_class = 'badge-info';
                }else{
                    $color_class = 'badge-danger';
                }
                $id = base64_encode($post_val->id);
                $status = "<span class='badge {$color_class}'>{$post_val->findLead->client_status}</span>";

                $data_val[] = [
                    'id'            => $index + 1 + $start_val,
                    'name'          => $post_val->name,
                    'email'         => $post_val->email,
                    'phone'         => $post_val->phone ?? 'N/A',
                    'sale_type'     => ($post_val->findLead->sale_type) ?? 'N/A',
                    'status_id'     => $status,
                    'options'       => "<div class='btn-group'>
                                      " . (Gate::allows("view.clients") ? "<a class='btn btn-primary btn-style' href='" . route('view.clients', ['id' => $id]) . "'><i class='fa fa-eye'></i></a>" : "") . "
                                    </div>",
//                    agr delete ka bola tou upper div mein paste krna ha
//                    " . (Gate::allows("delete.client") ? "<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i></button>" : "") . "
//                    " . (Gate::allows("edit.clients") ? "<a class='btn btn-primary btn-style' href='" . route('edit.clients', ['id' => $id]) . "' title='Edit'><i class='fa fa-edit'></i></a>" : "") . "
//                                                      " . (Gate::allows("view-info.clients") ? "<a class='btn btn-success btn-style' href='" . route('view-info.clients', ['id' => $id]) . "'><i class='fa fa-eye'> View Details</i></a>" : "") . "
                ];
            }
        }

        return response()->json([
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data" => $data_val
        ]);
    }

    public function getStates($name)
    {
        if(!isset($name)) {
            $name = 'United States';
        }

        $country = Country::where('name',trim($name))->first();
        $states = [];
        if($country)
        {
            $states = State::where('country_id',$country->id)->orderBy('name', 'ASC')->get();
        }

        return response()->json(['stats'=>true,'states'=>$states]);
    }

    public function getCities($name)
    {
        $state = State::where('name',trim($name))->first();
        $cities = [];
        if($state)
        {
            $cities = City::where('state_id',$state->id)->get();
        }

        return response()->json(['stats'=>true,'cities'=>$cities]);
    }

    public function createClient(){
        $countries = Country::get();

        return view('new-clients.create',compact('countries'));
    }

    public function store(Request $request){
//        dd($request->all());
        $request->validate([
            'firstname'             => 'required|string',
            'lastname'              => 'required|string',
            'email'                 => 'required|email|unique:users',
            'password'              => 'required|min:4',
            'phone'                 => 'required',
            'country'               => 'required',
            'state'                 => 'required',
            'city'                  => 'required',
            'postal_code'           => 'required',
            'ip_address'            => 'required|unique:ip_addresses',
        ]);

        $logo_refrence = [];

        if ($request->file('logo_refrence_material')) {
            foreach ($request->file('logo_refrence_material') as $file) {
                $fileName = $file->getClientOriginalName();
                $file->move(public_path('client-logo/images'), $fileName);
                $logo_refrence[] = $fileName;
            }
        }
//        dd($logo_refrence);


         $user =    User::create([
                'user_type_id'          =>    2,
                'firstname'             =>    $request->firstname,
                'lastname'              =>    $request->lastname,
                'name'                  =>    $request->firstname ." ".$request->lastname,
                'client_display_name'   =>    $request->firstname ." ".$request->lastname,
                'email'                 =>    $request->email,
                'password'              =>    Hash::make($request->password),
                'phone'                 =>    $request->phone,
                'country'               =>    $request->country,
                'state'                 =>    $request->state,
                'city'                  =>    $request->city,
                'country_id'            =>    $request->country_id,
                'state_id'              =>    $request->state_id,
                'city_id'               =>    $request->city_id,
                'postal_code'           =>    $request->postal_code,
                'ip_address'            =>    $request->ip_address,
         ]);


        ClientsInformation::create([
            'user_id'                       =>    $user->id,
            'firstname'                     =>    $request->firstname,
            'lastname'                      =>    $request->lastname,
            'email'                         =>    $request->email,
            'phone'                         =>    $request->phone,
            'product_type'                  =>    $request->product_type,
            'web_url'                       =>    $request->web_url,
            'comments'                      =>    $request->comments,
            'logo_exact_name'               =>    $request->logo_exact_name,
            'logo_slogan'                   =>    $request->logo_slogan,
            'look_and_feel'                 =>    $request->look_and_feel,
            'logo_competitor_ref'           =>    $request->logo_competitor_ref,
            'logo_primary_color'            =>    $request->logo_primary_color,
            'logo_secondary_color'          =>    $request->logo_secondary_color,
            'logo_industry'                 =>    $request->logo_industry,
            'logo_targeted_audience'        =>    $request->logo_targeted_audience,
            'logo_typography'               =>    $request->logo_typography,
            'logo_type'                     =>    $request->logo_type,
            'animation_years_business_existence'    =>    $request->animation_years_business_existence,
            'animation_video_purpose'       =>    $request->animation_video_purpose,
            'animation_target_audience'     =>    $request->animation_target_audience,
            'animation_voiceover_gender'    =>    $request->animation_voiceover_gender,
            'animation_voiceover_accent'    =>    $request->animation_voiceover_accent,
            'animation_voiceover_type'      =>    $request->animation_voiceover_type,
            'animation_business_detail'     =>    $request->animation_business_detail,
            'animation_video_duration'      =>    $request->animation_video_duration,
            'website_current_web_host'      =>    $request->website_current_web_host,
            'website_domain_purchased'      =>    $request->website_domain_purchased,
            'website_providing_image'       =>    $request->website_providing_image,
            'website_have_content'          =>    $request->website_have_content,
            'website_company_desc'          =>    $request->website_company_desc,
            'website_specific_theme'        =>    $request->website_specific_theme,
            'website_what_colors'           =>    $request->website_what_colors,
            'website_sites_you_admire'      =>    $request->website_sites_you_admire,
            'website_additional_information'=>    $request->website_additional_information,
            'website_site_pages'            =>    $request->website_site_pages,
            'website_your_services'         =>    $request->website_your_services,
            'website_better_competition'    =>    $request->website_better_competition,
            'website_attract_new_customers' =>    $request->website_attract_new_customers,
            'logo_refrence_material'        =>    (empty($logo_refrence) == false) ? serialize($logo_refrence) : '',
            'logo_name'                     =>    $request->logo_name,
            'billing_package'               =>    $request->billing_package,
            'billing_amount'                =>    $request->billing_amount,
            'cardholder_name'               =>    $request->cardholder_name,
            'credit_card_number'            =>    $request->credit_card_number,
            'credit_card_cvc'               =>    $request->credit_card_cvc,
            'month'                         =>    $request->month,
            'year'                          =>    $request->year,
            'credit_card_zip'               =>    $request->credit_card_zip,
        ]);

        LeadsToClient::create([
            'user_id'           =>    $user->id,
            'client_type'       =>    $request->client_type,
            'client_status'     =>    $request->client_status,
            'sale_type'         =>    $request->product_type,
            'project_type'      =>    $request->pkg_name,
            'source'            =>    $request->source,
            'brand'             =>    $request->brand,
//            'payment_amount'    =>    $request->amount,
//            'payment_date'      =>    Carbon::now(),
        ]);

        Payment::create([
            'user_id'               => $user->id,
            'dated'                 => Carbon::now(),
            'pkg_name'              => $request->pkg_name,
            'product_type'          => $request->product_type,
            'actual_pkg_price'      => $request->actual_pkg_price,
            'discounted_pkg_price'  => $request->discounted_pkg_price,
            'amount'                => $request->amount,
            'payment_type'          => $request->payment_type,
            'status'                => "Upsell" ,
        ]);

        $comm   = $request->client_type ." created by ". auth()->user()->name .". On create its status is ". $request->client_status;
        $comments = UserToComment::create([
            'user_id'   => $user->id,
            'comments'  => $comm,
        ]);

        Slack::to('#teamwork-development')->send('This is a line of text in a channel.<br> And this is another line of text.');

        if ($request->client_type == 'Client') {
            return redirect()->route('clients')->with('mesg', 'Client created successfully');
        }else if($request->client_type == 'Lead'){
            return redirect()->route('leads')->with('mesg', 'Lead created successfully');
        }
    }

    public function show($id){
        $client = User::find(base64_decode($id));
        if (!$client){
            return redirect()->back()->with('error', 'Client not found');
        }
        $client_info = ClientsInformation::where('user_id', $client->id)->first();
        if (isset($client_info) && $client_info->product_type == 'LOGO') {
            $logo_refrence_material = unserialize($client_info->logo_refrence_material);
        }else{
            $logo_refrence_material = '';
        }
        $projects = Project::where('client_id', $client->id)->get();
        $payments = Payment::where('user_id',$client->id)->orderBy('dated','DESC')->get();
        $comments = UserToComment::where('user_id',$client->id)->orderBy('id','DESC')->get();

        return view('new-clients.show', compact('client', 'projects','payments','comments', 'client_info','logo_refrence_material'));
    }

    public function storePayment(Request $request)
    {

        $request->validate([
            'date'              => 'required',
            'pkg_name'          => 'required',
            'payment_type'      => 'required',
            'amount'            => 'required',
        ]);
//        dd($request->all());

        Payment::create([
            'user_id'               => $request->user_id,
            'dated'                 => $request->date,
            'pkg_name'              => $request->pkg_name,
            'product_type'          => $request->product_type,
            'actual_pkg_price'      => $request->actual_pkg_price,
            'discounted_pkg_price'  => $request->discounted_pkg_price,
            'amount'                => $request->amount,
            'payment_type'          => $request->payment_type,
            'description'           => $request->desc,
            'status'                => ($request->form_type == 'Upsell') ? $request->form_type : $request->form_type ,
        ]);

        $client_status =  LeadsToClient::where(['user_id'=>$request->user_id])->update([
            'client_type'           =>    $request->client_type,
            'client_status'         =>    $request->client_status,
        ]);

        $mesg_html = "Form Type: " . (($request->form_type == 'Upsell') ? $request->form_type : $request->form_type) . " created by: " . auth()->user()->name ." Product: ". $request->product_type ." Package: ". $request->pkg_name.  " Amount: $".$request->amount. " Payment Type: ".$request->payment_type. " and status changed to ".$request->client_status .".";

        $comments = UserToComment::create([
            'user_id'   => $request->user_id,
            'comments'  => $mesg_html,
        ]);


        return redirect()->back()->with('mesg', 'Payment created successfully');
    }

    public function saveComment(Request $request){

        $comm   = $request->comments  .". (Comment added by ". auth()->user()->name ." )";
        $comments = UserToComment::create([
            'user_id'   => $request->id,
            'comments'  => $comm,
        ]);

        return response()->json(['comments'=>$comments->comments,'date'=>date('d-M-Y',strtotime($comments->created_at)),'message' => 'Comment successfully!']);
    }

    public function clientInformation($id){
        $client = User::where('id',base64_decode($id))->first();
//        dd($client);

        if (!$client){
            return redirect()->back()->with('error', 'Client not found');
        }
        $client_info = ClientsInformation::where('user_id', $client->id)->first();
        if (!$client_info){
            return redirect()->back()->with('error', 'Client information not found');
        }
        if ($client_info->product_type == 'LOGO') {
            $logo_refrence_material = unserialize($client_info->logo_refrence_material);
        }else{
            $logo_refrence_material = '';
        }

        return view('new-clients.client_information', compact('client', 'client_info','logo_refrence_material'));
    }
}
